/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.message.DataSpace;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeMessage
extends Message {
    private static final Logger logger = LoggerFactory.getLogger(AttributeMessage.class);
    private static final int DATA_TYPE_SHARED = 0;
    private static final int DATA_SPACE_SHARED = 0;
    private final byte version;
    private final String name;
    private final DataType dataType;
    private final DataSpace dataSpace;
    private final ByteBuffer data;

    public AttributeMessage(ByteBuffer bb, Superblock sb, BitSet messageFlags) {
        super(messageFlags);
        this.version = bb.get();
        logger.trace("Version: {}", (Object)this.version);
        if (this.version == 1) {
            bb.position(bb.position() + 1);
            int nameSize = Utils.readBytesAsUnsignedInt(bb, 2);
            int dataTypeSize = Utils.readBytesAsUnsignedInt(bb, 2);
            int dataSpaceSize = Utils.readBytesAsUnsignedInt(bb, 2);
            this.name = Utils.readUntilNull(Utils.createSubBuffer(bb, nameSize));
            logger.trace("Name: {}", (Object)this.name);
            Utils.seekBufferToNextMultipleOfEight(bb);
            this.dataType = DataType.readDataType(Utils.createSubBuffer(bb, dataTypeSize));
            logger.trace("Datatype: {}", (Object)this.dataType);
            Utils.seekBufferToNextMultipleOfEight(bb);
            this.dataSpace = DataSpace.readDataSpace(Utils.createSubBuffer(bb, dataSpaceSize), sb);
            logger.trace("Dataspace: {}", (Object)this.dataSpace);
            Utils.seekBufferToNextMultipleOfEight(bb);
            int dataSize = Math.toIntExact(this.dataSpace.getTotalLength() * (long)this.dataType.getSize());
            this.data = dataSize == 0 ? null : Utils.createSubBuffer(bb, dataSize);
        } else if (this.version == 2) {
            BitSet flags = BitSet.valueOf(new byte[]{bb.get()});
            int nameSize = Utils.readBytesAsUnsignedInt(bb, 2);
            int dataTypeSize = Utils.readBytesAsUnsignedInt(bb, 2);
            int dataSpaceSize = Utils.readBytesAsUnsignedInt(bb, 2);
            this.name = Utils.readUntilNull(Utils.createSubBuffer(bb, nameSize));
            logger.trace("Name: {}", (Object)this.name);
            if (flags.get(0)) {
                throw new UnsupportedHdfException("Attribute [" + this.name + "] contains shared data type");
            }
            this.dataType = DataType.readDataType(Utils.createSubBuffer(bb, dataTypeSize));
            logger.trace("Datatype: {}", (Object)this.dataType);
            if (flags.get(0)) {
                throw new UnsupportedHdfException("Attribute [" + this.name + "]  contains shared data space");
            }
            this.dataSpace = DataSpace.readDataSpace(Utils.createSubBuffer(bb, dataSpaceSize), sb);
            logger.trace("Dataspace: {}", (Object)this.dataSpace);
            int dataSize = Math.toIntExact(this.dataSpace.getTotalLength() * (long)this.dataType.getSize());
            this.data = dataSize == 0 ? null : Utils.createSubBuffer(bb, dataSize);
        } else if (this.version == 3) {
            Charset charset;
            BitSet flags = BitSet.valueOf(new byte[]{bb.get()});
            int nameSize = Utils.readBytesAsUnsignedInt(bb, 2);
            int dataTypeSize = Utils.readBytesAsUnsignedInt(bb, 2);
            int dataSpaceSize = Utils.readBytesAsUnsignedInt(bb, 2);
            byte characterEncoding = bb.get();
            switch (characterEncoding) {
                case 0: {
                    charset = StandardCharsets.US_ASCII;
                    break;
                }
                case 1: {
                    charset = StandardCharsets.UTF_8;
                    break;
                }
                default: {
                    throw new UnsupportedHdfException("Unrecognized character set detected: " + characterEncoding);
                }
            }
            ByteBuffer nameBuffer = Utils.createSubBuffer(bb, nameSize);
            this.name = charset.decode(nameBuffer).toString().trim();
            logger.trace("Name: {}", (Object)this.name);
            if (flags.get(0)) {
                throw new UnsupportedHdfException("Attribute [" + this.name + "] contains shared data type");
            }
            this.dataType = DataType.readDataType(Utils.createSubBuffer(bb, dataTypeSize));
            logger.trace("Datatype: {}", (Object)this.dataType);
            if (flags.get(0)) {
                throw new UnsupportedHdfException("Attribute [" + this.name + "]  contains shared data space");
            }
            this.dataSpace = DataSpace.readDataSpace(Utils.createSubBuffer(bb, dataSpaceSize), sb);
            logger.trace("Dataspace: {}", (Object)this.dataSpace);
            int dataSize = Math.toIntExact(this.dataSpace.getTotalLength() * (long)this.dataType.getSize());
            this.data = dataSize == 0 ? null : Utils.createSubBuffer(bb, dataSize);
        } else {
            throw new UnsupportedHdfException("Unsupported Attribute message version. Detected version: " + this.version);
        }
        logger.debug("Read attribute: {}", (Object)this.name);
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public DataSpace getDataSpace() {
        return this.dataSpace;
    }

    public ByteBuffer getDataBuffer() {
        if (this.data == null) {
            return null;
        }
        return this.data.slice().order(this.data.order());
    }

    public String toString() {
        return "AttributeMessage [name=" + this.name + ", dataType=" + this.dataType + ", dataSpace=" + this.dataSpace + "]";
    }
}

