/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class AttributeInfoMessage
extends Message {
    private static final int MAXIMUM_CREATION_INDEX_PRESENT = 0;
    private static final int ATTRIBUTE_CREATION_ORDER_PRESENT = 1;
    private final int maximumCreationIndex;
    private final long fractalHeapAddress;
    private final long attributeNameBTreeAddress;
    private final long attributeCreationOrderBTreeAddress;

    AttributeInfoMessage(ByteBuffer bb, Superblock sb, BitSet messageFlags) {
        super(messageFlags);
        byte version = bb.get();
        if (version != 0) {
            throw new HdfException("Unrecognized version " + version);
        }
        BitSet flags = BitSet.valueOf(new byte[]{bb.get()});
        this.maximumCreationIndex = flags.get(0) ? Utils.readBytesAsUnsignedInt(bb, 2) : -1;
        this.fractalHeapAddress = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets());
        this.attributeNameBTreeAddress = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets());
        this.attributeCreationOrderBTreeAddress = flags.get(1) ? Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets()) : -1L;
    }

    public int getMaximumCreationIndex() {
        return this.maximumCreationIndex;
    }

    public long getFractalHeapAddress() {
        return this.fractalHeapAddress;
    }

    public long getAttributeNameBTreeAddress() {
        return this.attributeNameBTreeAddress;
    }

    public long getAttributeCreationOrderBTreeAddress() {
        return this.attributeCreationOrderBTreeAddress;
    }
}

