/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.datatype.DataType;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StringData
extends DataType {
    private final PaddingType paddingType;
    private final Charset charset;

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfFileChannel hdfFc) {
        Object data = Array.newInstance(this.getJavaType(), dimensions);
        StringData.fillFixedLengthStringData(data, dimensions, buffer, this.getSize(), this.getCharset(), this.getStringPaddingHandler());
        return data;
    }

    private static void fillFixedLengthStringData(Object data, int[] dims, ByteBuffer buffer, int stringLength, Charset charset, StringPaddingHandler stringPaddingHandler) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                StringData.fillFixedLengthStringData(newArray, Utils.stripLeadingIndex(dims), buffer, stringLength, charset, stringPaddingHandler);
            }
        } else {
            for (int i = 0; i < dims[0]; ++i) {
                ByteBuffer elementBuffer = Utils.createSubBuffer(buffer, stringLength);
                stringPaddingHandler.setBufferLimit(elementBuffer);
                Array.set(data, i, charset.decode(elementBuffer).toString());
            }
        }
    }

    public StringData(ByteBuffer bb) {
        super(bb);
        int paddingTypeValue = Utils.bitsToInt(this.classBits, 0, 4);
        switch (paddingTypeValue) {
            case 0: {
                this.paddingType = PaddingType.NULL_TERMINATED;
                break;
            }
            case 1: {
                this.paddingType = PaddingType.NULL_PADDED;
                break;
            }
            case 2: {
                this.paddingType = PaddingType.SPACE_PADDED;
                break;
            }
            default: {
                throw new HdfException("Unrecognized padding type. Value is: " + paddingTypeValue);
            }
        }
        int charsetIndex = Utils.bitsToInt(this.classBits, 4, 4);
        switch (charsetIndex) {
            case 0: {
                this.charset = StandardCharsets.US_ASCII;
                break;
            }
            case 1: {
                this.charset = StandardCharsets.UTF_8;
                break;
            }
            default: {
                throw new HdfException("Unrecognized Charset. Index is: " + charsetIndex);
            }
        }
    }

    public PaddingType getPaddingType() {
        return this.paddingType;
    }

    public StringPaddingHandler getStringPaddingHandler() {
        return this.paddingType.stringPaddingHandler;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Class<?> getJavaType() {
        return String.class;
    }

    public String toString() {
        return "StringData{paddingType=" + (Object)((Object)this.paddingType) + ", charset=" + this.charset + '}';
    }

    static class SpacePadded
    implements StringPaddingHandler {
        SpacePadded() {
        }

        @Override
        public void setBufferLimit(ByteBuffer byteBuffer) {
            int i;
            for (i = byteBuffer.limit() - 1; i >= 0 && byteBuffer.get(i) == 32; --i) {
            }
            byteBuffer.limit(i + 1);
        }
    }

    static class NullPadded
    implements StringPaddingHandler {
        NullPadded() {
        }

        @Override
        public void setBufferLimit(ByteBuffer byteBuffer) {
            int i;
            for (i = byteBuffer.limit() - 1; i >= 0 && byteBuffer.get(i) == 0; --i) {
            }
            byteBuffer.limit(i + 1);
        }
    }

    static class NullTerminated
    implements StringPaddingHandler {
        NullTerminated() {
        }

        @Override
        public void setBufferLimit(ByteBuffer byteBuffer) {
            int i;
            int limit = byteBuffer.limit();
            for (i = 0; i < limit && byteBuffer.get(i) != 0; ++i) {
            }
            byteBuffer.limit(i);
        }
    }

    public static interface StringPaddingHandler {
        public void setBufferLimit(ByteBuffer var1);
    }

    public static enum PaddingType {
        NULL_TERMINATED(new NullTerminated()),
        NULL_PADDED(new NullPadded()),
        SPACE_PADDED(new SpacePadded());

        private final StringPaddingHandler stringPaddingHandler;

        private PaddingType(StringPaddingHandler stringPaddingHandler) {
            this.stringPaddingHandler = stringPaddingHandler;
        }
    }
}

