/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.HdfTypeException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Reference
extends DataType {
    private final ReferenceType type;

    public Reference(ByteBuffer bb) {
        super(bb);
        int rawType = Utils.bitsToInt(this.classBits, 0, 4);
        switch (rawType) {
            case 0: {
                this.type = ReferenceType.OBJECT;
                break;
            }
            case 1: {
                this.type = ReferenceType.REGION;
                throw new UnsupportedHdfException("Dataset Region references not supported for Reference data type");
            }
            default: {
                throw new HdfException("Unrecognized Reference type. Index is: " + rawType);
            }
        }
    }

    public ReferenceType getType() {
        return this.type;
    }

    @Override
    public Class<?> getJavaType() {
        if (this.getSize() > 8) {
            throw new HdfTypeException("Unsupported address size in reference data type " + this.getSize() + "bytes");
        }
        return Long.TYPE;
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfFileChannel hdfFc) {
        Object data = Array.newInstance(this.getJavaType(), dimensions);
        this.fillData(data, dimensions, buffer.order(ByteOrder.LITTLE_ENDIAN));
        return data;
    }

    private void fillData(Object data, int[] dims, ByteBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                this.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            for (int i = 0; i < Array.getLength(data); ++i) {
                Array.set(data, i, Utils.readBytesAsUnsignedLong(buffer, this.getSize()));
            }
        }
    }

    public static enum ReferenceType {
        OBJECT,
        REGION;

    }
}

