/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfTypeException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class FloatingPoint
extends DataType
implements OrderedDataType {
    private final ByteOrder order;
    private final boolean lowPadding;
    private final boolean highPadding;
    private final boolean internalPadding;
    private final int mantissaNormalization;
    private final int signLocation;
    private final short bitOffset;
    private final short bitPrecision;
    private final byte exponentLocation;
    private final byte exponentSize;
    private final byte mantissaLocation;
    private final byte mantissaSize;
    private final int exponentBias;

    public FloatingPoint(ByteBuffer bb) {
        super(bb);
        if (this.classBits.get(6)) {
            throw new UnsupportedHdfException("VAX endian is not supported");
        }
        this.order = this.classBits.get(0) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.lowPadding = this.classBits.get(1);
        this.highPadding = this.classBits.get(2);
        this.internalPadding = this.classBits.get(3);
        this.mantissaNormalization = Utils.bitsToInt(this.classBits, 4, 2);
        this.signLocation = Utils.bitsToInt(this.classBits, 8, 8);
        this.bitOffset = bb.getShort();
        this.bitPrecision = bb.getShort();
        this.exponentLocation = bb.get();
        this.exponentSize = bb.get();
        this.mantissaLocation = bb.get();
        this.mantissaSize = bb.get();
        this.exponentBias = bb.getInt();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.order;
    }

    public boolean isLowPadding() {
        return this.lowPadding;
    }

    public boolean isHighPadding() {
        return this.highPadding;
    }

    public boolean isInternalPadding() {
        return this.internalPadding;
    }

    public int getMantissaNormalization() {
        return this.mantissaNormalization;
    }

    public int getSignLocation() {
        return this.signLocation;
    }

    public short getBitOffset() {
        return this.bitOffset;
    }

    public short getBitPrecision() {
        return this.bitPrecision;
    }

    public byte getExponentLocation() {
        return this.exponentLocation;
    }

    public byte getExponentSize() {
        return this.exponentSize;
    }

    public byte getMantissaLocation() {
        return this.mantissaLocation;
    }

    public byte getMantissaSize() {
        return this.mantissaSize;
    }

    public int getExponentBias() {
        return this.exponentBias;
    }

    @Override
    public Class<?> getJavaType() {
        switch (this.bitPrecision) {
            case 16: 
            case 32: {
                return Float.TYPE;
            }
            case 64: {
                return Double.TYPE;
            }
        }
        throw new HdfTypeException("Unsupported signed fixed point data type");
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfFileChannel hdfFc) {
        Object data = Array.newInstance(this.getJavaType(), dimensions);
        ByteOrder byteOrder = this.getByteOrder();
        switch (this.getSize()) {
            case 2: {
                FloatingPoint.fillData(data, dimensions, buffer.order(byteOrder).asShortBuffer());
                break;
            }
            case 4: {
                FloatingPoint.fillData(data, dimensions, buffer.order(byteOrder).asFloatBuffer());
                break;
            }
            case 8: {
                FloatingPoint.fillData(data, dimensions, buffer.order(byteOrder).asDoubleBuffer());
                break;
            }
            default: {
                throw new HdfTypeException("Unsupported floating point type size " + this.getSize() + " bytes");
            }
        }
        return data;
    }

    private static void fillData(Object data, int[] dims, ShortBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FloatingPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            float[] floatData = (float[])data;
            for (int i = 0; i < dims[0]; ++i) {
                short element = buffer.get();
                floatData[i] = FloatingPoint.toFloat(element);
            }
        }
    }

    public static float toFloat(short element) {
        int mant = element & 0x3FF;
        int exp = element & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            exp += 114688;
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((element & 0x8000) << 16 | (exp | mant) << 13);
    }

    private static void fillData(Object data, int[] dims, FloatBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FloatingPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((float[])data);
        }
    }

    private static void fillData(Object data, int[] dims, DoubleBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FloatingPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((double[])data);
        }
    }
}

