/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.dataset.EnumDatasetReader;
import io.jhdf.object.datatype.DataType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class EnumDataType
extends DataType {
    private final DataType baseType;
    private final Map<Integer, String> ordinalToName;

    public EnumDataType(ByteBuffer bb) {
        super(bb);
        int i;
        int i2;
        this.baseType = DataType.readDataType(bb);
        int numberOfMembers = Utils.bitsToInt(this.classBits, 0, 16);
        ArrayList<String> names = new ArrayList<String>();
        if (this.getVersion() == 3) {
            for (i2 = 0; i2 < numberOfMembers; ++i2) {
                names.add(Utils.readUntilNull(bb));
            }
        } else {
            for (i2 = 0; i2 < numberOfMembers; ++i2) {
                int posBeforeName = bb.position();
                names.add(Utils.readUntilNull(bb));
                int posAfterName = bb.position();
                int bytesPastEight = (posAfterName - posBeforeName) % 8;
                if (bytesPastEight == 0) continue;
                int bytesToSkip = 8 - bytesPastEight;
                bb.position(bb.position() + bytesToSkip);
            }
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (i = 0; i < numberOfMembers; ++i) {
            values.add(Utils.readBytesAsUnsignedInt(bb, this.baseType.getSize()));
        }
        this.ordinalToName = new HashMap<Integer, String>();
        for (i = 0; i < numberOfMembers; ++i) {
            this.ordinalToName.put((Integer)values.get(i), (String)names.get(i));
        }
    }

    @Override
    public Class<?> getJavaType() {
        return String.class;
    }

    public DataType getBaseType() {
        return this.baseType;
    }

    public Map<Integer, String> getEnumMapping() {
        return this.ordinalToName;
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfFileChannel hdfFc) {
        return EnumDatasetReader.readEnumDataset(this, buffer, dimensions);
    }
}

