/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.ArrayDataType;
import io.jhdf.object.datatype.BitField;
import io.jhdf.object.datatype.CompoundDataType;
import io.jhdf.object.datatype.EnumDataType;
import io.jhdf.object.datatype.FixedPoint;
import io.jhdf.object.datatype.FloatingPoint;
import io.jhdf.object.datatype.Reference;
import io.jhdf.object.datatype.StringData;
import io.jhdf.object.datatype.VariableLength;
import java.nio.ByteBuffer;
import java.util.BitSet;

public abstract class DataType {
    private final int version;
    private final int dataClass;
    private final int size;
    protected final BitSet classBits;

    public static DataType readDataType(ByteBuffer bb) {
        bb.mark();
        BitSet classAndVersion = BitSet.valueOf(new byte[]{bb.get()});
        int version = Utils.bitsToInt(classAndVersion, 4, 4);
        int dataClass = Utils.bitsToInt(classAndVersion, 0, 4);
        if (version == 0 || version > 3) {
            throw new HdfException("Unrecognized datatype version '" + version + "' detected");
        }
        bb.reset();
        switch (dataClass) {
            case 0: {
                return new FixedPoint(bb);
            }
            case 1: {
                return new FloatingPoint(bb);
            }
            case 2: {
                throw new UnsupportedHdfException("Time data type is not yet supported");
            }
            case 3: {
                return new StringData(bb);
            }
            case 4: {
                return new BitField(bb);
            }
            case 5: {
                throw new UnsupportedHdfException("Opaque data type is not yet supported");
            }
            case 6: {
                return new CompoundDataType(bb);
            }
            case 7: {
                return new Reference(bb);
            }
            case 8: {
                return new EnumDataType(bb);
            }
            case 9: {
                return new VariableLength(bb);
            }
            case 10: {
                return new ArrayDataType(bb);
            }
        }
        throw new HdfException("Unrecognized data class = " + dataClass);
    }

    protected DataType(ByteBuffer bb) {
        BitSet classAndVersion = BitSet.valueOf(new byte[]{bb.get()});
        this.dataClass = Utils.bitsToInt(classAndVersion, 0, 4);
        this.version = Utils.bitsToInt(classAndVersion, 4, 4);
        byte[] classBytes = new byte[3];
        bb.get(classBytes);
        this.classBits = BitSet.valueOf(classBytes);
        this.size = Utils.readBytesAsUnsignedInt(bb, 4);
    }

    public int getVersion() {
        return this.version;
    }

    public int getDataClass() {
        return this.dataClass;
    }

    public int getSize() {
        return this.size;
    }

    public abstract Class<?> getJavaType();

    public abstract Object fillData(ByteBuffer var1, int[] var2, HdfFileChannel var3);
}

