/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.dataset.CompoundDatasetReader;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class CompoundDataType
extends DataType {
    private final List<CompoundDataMember> members;

    public CompoundDataType(ByteBuffer bb) {
        super(bb);
        int version = this.getVersion();
        if (version > 3) {
            throw new UnsupportedHdfException("Compound data type version is not yet supported: version = " + version);
        }
        int numberOfMembers = Utils.bitsToInt(this.classBits, 0, 16);
        this.members = new ArrayList<CompoundDataMember>(numberOfMembers);
        for (int i = 0; i < numberOfMembers; ++i) {
            int offset;
            int posAfterName;
            int bytesPastEight;
            int posBeforeName = bb.position();
            String name = Utils.readUntilNull(bb);
            if (version < 3 && (bytesPastEight = ((posAfterName = bb.position()) - posBeforeName) % 8) != 0) {
                int bytesToSkip = 8 - bytesPastEight;
                bb.position(bb.position() + bytesToSkip);
            }
            if (version < 3) {
                offset = Utils.readBytesAsUnsignedInt(bb, 4);
            } else {
                int offsetBytes = Utils.bytesNeededToHoldNumber(this.getSize());
                offset = Utils.readBytesAsUnsignedInt(bb, offsetBytes);
            }
            int[] dimensionSize = null;
            if (version == 1) {
                int dimensionality = Utils.readBytesAsUnsignedInt(bb, 1);
                bb.position(bb.position() + 3 + 4 + 4);
                dimensionSize = new int[dimensionality];
                for (int j = 0; j < 4; ++j) {
                    int dimSize = Utils.readBytesAsUnsignedInt(bb, 4);
                    if (j >= dimensionality) continue;
                    dimensionSize[j] = dimSize;
                }
            }
            DataType memberDataType = DataType.readDataType(bb);
            this.members.add(new CompoundDataMember(name, dimensionSize, offset, memberDataType));
        }
    }

    @Override
    public Class<?> getJavaType() {
        return Map.class;
    }

    public List<CompoundDataMember> getMembers() {
        return this.members;
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfFileChannel hdfFc) {
        return CompoundDatasetReader.readDataset(this, buffer, dimensions, hdfFc);
    }

    public static class CompoundDataMember {
        private final String name;
        private final int[] dimensionSize;
        private final int offset;
        private final DataType dataType;

        private CompoundDataMember(String name, int[] dimensionSize, int offset, DataType dataType) {
            this.name = name;
            this.dimensionSize = dimensionSize;
            this.offset = offset;
            this.dataType = dataType;
        }

        public String getName() {
            return this.name;
        }

        public int[] getDimensionSize() {
            return ArrayUtils.clone((int[])this.dimensionSize);
        }

        public int getOffset() {
            return this.offset;
        }

        public DataType getDataType() {
            return this.dataType;
        }
    }
}

