/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked.indexing;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.DatasetInfo;
import io.jhdf.dataset.chunked.indexing.ChunkImpl;
import io.jhdf.dataset.chunked.indexing.ChunkIndex;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;

public class FixedArrayIndex
implements ChunkIndex {
    private static final byte[] FIXED_ARRAY_HEADER_SIGNATURE = "FAHD".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FIXED_ARRAY_DATA_BLOCK_SIGNATURE = "FADB".getBytes(StandardCharsets.US_ASCII);
    private final long address;
    private final int unfilteredChunkSize;
    private final int[] datasetDimensions;
    private final int[] chunkDimensions;
    private final int clientId;
    private final int entrySize;
    private final int pageBits;
    private final int maxNumberOfEntries;
    private final long dataBlockAddress;
    private final List<Chunk> chunks;

    public FixedArrayIndex(HdfFileChannel hdfFc, long address, DatasetInfo datasetInfo) {
        this.address = address;
        this.unfilteredChunkSize = datasetInfo.getChunkSizeInBytes();
        this.datasetDimensions = datasetInfo.getDatasetDimensions();
        this.chunkDimensions = datasetInfo.getChunkDimensions();
        int headerSize = 12 + hdfFc.getSizeOfOffsets() + hdfFc.getSizeOfLengths();
        ByteBuffer bb = hdfFc.readBufferFromAddress(address, headerSize);
        byte[] formatSignatureBytes = new byte[4];
        bb.get(formatSignatureBytes, 0, formatSignatureBytes.length);
        if (!Arrays.equals(FIXED_ARRAY_HEADER_SIGNATURE, formatSignatureBytes)) {
            throw new HdfException("Fixed array header signature 'FAHD' not matched, at address " + address);
        }
        byte version = bb.get();
        if (version != 0) {
            throw new HdfException("Unsupported fixed array index version detected. Version: " + version);
        }
        this.clientId = bb.get();
        this.entrySize = bb.get();
        this.pageBits = bb.get();
        this.maxNumberOfEntries = Utils.readBytesAsUnsignedInt(bb, hdfFc.getSizeOfLengths());
        this.dataBlockAddress = Utils.readBytesAsUnsignedLong(bb, hdfFc.getSizeOfOffsets());
        this.chunks = new ArrayList<Chunk>(this.maxNumberOfEntries);
        new FixedArrayDataBlock(this, hdfFc, this.dataBlockAddress);
    }

    @Override
    public Collection<Chunk> getAllChunks() {
        return this.chunks;
    }

    private static class FixedArrayDataBlock {
        private FixedArrayDataBlock(FixedArrayIndex fixedArrayIndex, HdfFileChannel hdfFc, long address) {
            int headerSize = 6 + hdfFc.getSizeOfOffsets() + fixedArrayIndex.entrySize * fixedArrayIndex.maxNumberOfEntries;
            ByteBuffer bb = hdfFc.readBufferFromAddress(address, headerSize);
            byte[] formatSignatureBytes = new byte[4];
            bb.get(formatSignatureBytes, 0, formatSignatureBytes.length);
            if (!Arrays.equals(FIXED_ARRAY_DATA_BLOCK_SIGNATURE, formatSignatureBytes)) {
                throw new HdfException("Fixed array data block signature 'FADB' not matched, at address " + address);
            }
            byte version = bb.get();
            if (version != 0) {
                throw new HdfException("Unsupported fixed array data block version detected. Version: " + version);
            }
            byte clientId = bb.get();
            if (clientId != fixedArrayIndex.clientId) {
                throw new HdfException("Fixed array client ID mismatch. Possible file corruption detected");
            }
            long headerAddress = Utils.readBytesAsUnsignedLong(bb, hdfFc.getSizeOfOffsets());
            if (headerAddress != fixedArrayIndex.address) {
                throw new HdfException("Fixed array data block header address missmatch");
            }
            if (clientId == 0) {
                for (int i = 0; i < fixedArrayIndex.maxNumberOfEntries; ++i) {
                    long chunkAddress = Utils.readBytesAsUnsignedLong(bb, hdfFc.getSizeOfOffsets());
                    int[] chunkOffset = Utils.chunkIndexToChunkOffset(i, fixedArrayIndex.chunkDimensions, fixedArrayIndex.datasetDimensions);
                    fixedArrayIndex.chunks.add(new ChunkImpl(chunkAddress, fixedArrayIndex.unfilteredChunkSize, chunkOffset));
                }
            } else if (clientId == 1) {
                for (int i = 0; i < fixedArrayIndex.maxNumberOfEntries; ++i) {
                    long chunkAddress = Utils.readBytesAsUnsignedLong(bb, hdfFc.getSizeOfOffsets());
                    int chunkSizeInBytes = Utils.readBytesAsUnsignedInt(bb, fixedArrayIndex.entrySize - hdfFc.getSizeOfOffsets() - 4);
                    BitSet filterMask = BitSet.valueOf(new byte[]{bb.get(), bb.get(), bb.get(), bb.get()});
                    int[] chunkOffset = Utils.chunkIndexToChunkOffset(i, fixedArrayIndex.chunkDimensions, fixedArrayIndex.datasetDimensions);
                    fixedArrayIndex.chunks.add(new ChunkImpl(chunkAddress, chunkSizeInBytes, chunkOffset, filterMask));
                }
            } else {
                throw new HdfException("Unrecognized client ID  = " + clientId);
            }
        }
    }
}

