/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked.indexing;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.DatasetInfo;
import io.jhdf.dataset.chunked.indexing.ChunkImpl;
import io.jhdf.dataset.chunked.indexing.ChunkIndex;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;

public class ExtensibleArrayIndex
implements ChunkIndex {
    private static final byte[] EXTENSIBLE_ARRAY_HEADER_SIGNATURE = "EAHD".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] EXTENSIBLE_ARRAY_INDEX_BLOCK_SIGNATURE = "EAIB".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] EXTENSIBLE_ARRAY_DATA_BLOCK_SIGNATURE = "EADB".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] EXTENSIBLE_ARRAY_SECONDARY_BLOCK_SIGNATURE = "EASB".getBytes(StandardCharsets.US_ASCII);
    private final long headerAddress;
    private final int clientId;
    private final boolean filtered;
    private final int numberOfElementsInIndexBlock;
    private final int numberOfElements;
    private final int numberOfSecondaryBlocks;
    private final int blockOffsetSize;
    private final int dataBlockSize;
    private final int secondaryBlockSize;
    private final List<Chunk> chunks;
    private final int unfilteredChunkSize;
    private final int[] datasetDimensions;
    private final int[] chunkDimensions;
    private final int minNumberOfElementsInDataBlock;
    private final ExtensibleArrayCounter dataBlockElementCounter;
    private final int minNumberOfDataBlockPointers;
    private final ExtensibleArraySecondaryBlockPointerCounter secondaryBlockPointerCounter;
    private final int maxNumberOfElementsInDataBlockPageBits;
    private final int extensibleArrayElementSize;
    private int elementCounter = 0;

    public ExtensibleArrayIndex(HdfFileChannel hdfFc, long address, DatasetInfo datasetInfo) {
        this.headerAddress = address;
        this.unfilteredChunkSize = datasetInfo.getChunkSizeInBytes();
        this.datasetDimensions = datasetInfo.getDatasetDimensions();
        this.chunkDimensions = datasetInfo.getChunkDimensions();
        int headerSize = 16 + hdfFc.getSizeOfOffsets() + 6 * hdfFc.getSizeOfLengths();
        ByteBuffer bb = hdfFc.readBufferFromAddress(address, headerSize);
        this.verifySignature(bb, EXTENSIBLE_ARRAY_HEADER_SIGNATURE);
        byte version = bb.get();
        if (version != 0) {
            throw new HdfException("Unsupported extensible array index version detected. Version: " + version);
        }
        this.clientId = bb.get();
        if (this.clientId == 0) {
            this.filtered = false;
        } else if (this.clientId == 1) {
            this.filtered = true;
        } else {
            throw new UnsupportedHdfException("Extensible array unsupported client ID: " + this.clientId);
        }
        this.extensibleArrayElementSize = bb.get();
        byte maxNumberOfElementsBits = bb.get();
        this.blockOffsetSize = maxNumberOfElementsBits / 8;
        this.numberOfElementsInIndexBlock = bb.get();
        this.minNumberOfElementsInDataBlock = bb.get();
        this.dataBlockElementCounter = new ExtensibleArrayCounter(this.minNumberOfElementsInDataBlock);
        this.minNumberOfDataBlockPointers = bb.get();
        this.secondaryBlockPointerCounter = new ExtensibleArraySecondaryBlockPointerCounter(this.minNumberOfDataBlockPointers);
        this.maxNumberOfElementsInDataBlockPageBits = bb.get();
        this.numberOfSecondaryBlocks = Utils.readBytesAsUnsignedInt(bb, hdfFc.getSizeOfLengths());
        this.secondaryBlockSize = Utils.readBytesAsUnsignedInt(bb, hdfFc.getSizeOfLengths());
        int numberOfDataBlocks = Utils.readBytesAsUnsignedInt(bb, hdfFc.getSizeOfLengths());
        this.dataBlockSize = Utils.readBytesAsUnsignedInt(bb, hdfFc.getSizeOfLengths());
        int maxIndexSet = Utils.readBytesAsUnsignedInt(bb, hdfFc.getSizeOfLengths());
        this.chunks = new ArrayList<Chunk>(maxIndexSet);
        this.numberOfElements = Utils.readBytesAsUnsignedInt(bb, hdfFc.getSizeOfLengths());
        int indexBlockAddress = Utils.readBytesAsUnsignedInt(bb, hdfFc.getSizeOfLengths());
        new ExtensibleArrayIndexBlock(hdfFc, indexBlockAddress);
    }

    private void verifySignature(ByteBuffer bb, byte[] expectedSignature) {
        byte[] actualSignature = new byte[expectedSignature.length];
        bb.get(actualSignature, 0, expectedSignature.length);
        if (!Arrays.equals(expectedSignature, actualSignature)) {
            String signatureStr = new String(expectedSignature, StandardCharsets.US_ASCII);
            throw new HdfException("Signature '" + signatureStr + "' not matched, at address ");
        }
    }

    @Override
    public Collection<Chunk> getAllChunks() {
        return this.chunks;
    }

    static class ExtensibleArraySecondaryBlockPointerCounter {
        private static final int REPEATS = 2;
        private int numberOfPointers;
        private int counter = 0;

        ExtensibleArraySecondaryBlockPointerCounter(int initialNumberOfPointers) {
            this.numberOfPointers = initialNumberOfPointers;
        }

        public int getNextNumberOfPointers() {
            if (this.counter < 2) {
                ++this.counter;
            } else {
                this.numberOfPointers *= 2;
                this.counter = 1;
            }
            return this.numberOfPointers;
        }
    }

    static class ExtensibleArrayCounter {
        private final int minNumberOfElementsInDataBlock;
        private int blockSizeMultiplier = 1;
        private int numberOfBlocks = 1;
        private int blockCounter = 0;
        private boolean increaseNumberOfBlocksNext = false;

        ExtensibleArrayCounter(int initialNumberOfElements) {
            this.minNumberOfElementsInDataBlock = initialNumberOfElements;
        }

        public int getNextNumberOfChunks() {
            if (this.blockCounter < this.numberOfBlocks) {
                ++this.blockCounter;
            } else if (this.increaseNumberOfBlocksNext) {
                this.increaseNumberOfBlocksNext = false;
                this.numberOfBlocks *= 2;
                this.blockCounter = 1;
            } else {
                this.increaseNumberOfBlocksNext = true;
                this.blockSizeMultiplier *= 2;
                this.blockCounter = 1;
            }
            return this.blockSizeMultiplier * this.minNumberOfElementsInDataBlock;
        }

        public String toString() {
            return "ExtensibleArrayCounter{minNumberOfElementsInDataBlock=" + this.minNumberOfElementsInDataBlock + ", blockSizeMultiplier=" + this.blockSizeMultiplier + ", numberOfBlocks=" + this.numberOfBlocks + ", blockCounter=" + this.blockCounter + ", increaseNumberOfBlocksNext=" + this.increaseNumberOfBlocksNext + '}';
        }
    }

    private class ExtensibleArrayIndexBlock {
        private ExtensibleArrayIndexBlock(HdfFileChannel hdfFc, long address) {
            int i;
            int headerSize = 6 + hdfFc.getSizeOfOffsets() + hdfFc.getSizeOfOffsets() * ExtensibleArrayIndex.this.numberOfElementsInIndexBlock + 6 * ExtensibleArrayIndex.this.extensibleArrayElementSize + ExtensibleArrayIndex.this.numberOfSecondaryBlocks * hdfFc.getSizeOfOffsets() + 4;
            ByteBuffer bb = hdfFc.readBufferFromAddress(address, headerSize);
            ExtensibleArrayIndex.this.verifySignature(bb, EXTENSIBLE_ARRAY_INDEX_BLOCK_SIGNATURE);
            byte version = bb.get();
            if (version != 0) {
                throw new HdfException("Unsupported fixed array data block version detected. Version: " + version);
            }
            byte clientId = bb.get();
            if (clientId != ExtensibleArrayIndex.this.clientId) {
                throw new HdfException("Extensible array client ID mismatch. Possible file corruption detected");
            }
            long headerAddress = Utils.readBytesAsUnsignedLong(bb, hdfFc.getSizeOfOffsets());
            if (headerAddress != ExtensibleArrayIndex.this.headerAddress) {
                throw new HdfException("Extensible array data block header address mismatch");
            }
            boolean readElement = true;
            for (i = 0; readElement && i < ExtensibleArrayIndex.this.numberOfElementsInIndexBlock; ++i) {
                readElement = this.readElement(bb, hdfFc);
            }
            if (readElement && ExtensibleArrayIndex.this.numberOfElements > ExtensibleArrayIndex.this.numberOfElementsInIndexBlock) {
                long dataBlockAddress;
                for (i = 0; i < 6 && (dataBlockAddress = Utils.readBytesAsUnsignedLong(bb, hdfFc.getSizeOfOffsets())) != -1L; ++i) {
                    new ExtensibleArrayDataBlock(hdfFc, dataBlockAddress);
                }
            }
            for (i = 0; i < ExtensibleArrayIndex.this.numberOfSecondaryBlocks; ++i) {
                long secondaryBlockAddress = Utils.readBytesAsUnsignedLong(bb, hdfFc.getSizeOfOffsets());
                new ExtensibleArraySecondaryBlock(hdfFc, secondaryBlockAddress);
            }
        }

        private boolean readElement(ByteBuffer bb, HdfFileChannel hdfFc) {
            long chunkAddress = Utils.readBytesAsUnsignedLong(bb, hdfFc.getSizeOfOffsets());
            if (chunkAddress != -1L) {
                int[] chunkOffset = Utils.chunkIndexToChunkOffset(ExtensibleArrayIndex.this.elementCounter, ExtensibleArrayIndex.this.chunkDimensions, ExtensibleArrayIndex.this.datasetDimensions);
                if (ExtensibleArrayIndex.this.filtered) {
                    int chunkSizeInBytes = Utils.readBytesAsUnsignedInt(bb, ExtensibleArrayIndex.this.extensibleArrayElementSize - hdfFc.getSizeOfOffsets() - 4);
                    BitSet filterMask = BitSet.valueOf(new byte[]{bb.get(), bb.get(), bb.get(), bb.get()});
                    ExtensibleArrayIndex.this.chunks.add(new ChunkImpl(chunkAddress, chunkSizeInBytes, chunkOffset, filterMask));
                } else {
                    ExtensibleArrayIndex.this.chunks.add(new ChunkImpl(chunkAddress, ExtensibleArrayIndex.this.unfilteredChunkSize, chunkOffset));
                }
                ExtensibleArrayIndex.this.elementCounter++;
                return true;
            }
            return false;
        }

        private class ExtensibleArraySecondaryBlock {
            private ExtensibleArraySecondaryBlock(HdfFileChannel hdfFc, long address) {
                long dataBlockAddress;
                int numberOfPointers = ExtensibleArrayIndex.this.secondaryBlockPointerCounter.getNextNumberOfPointers();
                int secondaryBlockSize = 6 + hdfFc.getSizeOfOffsets() + ExtensibleArrayIndex.this.blockOffsetSize + numberOfPointers * ExtensibleArrayIndex.this.extensibleArrayElementSize + 4;
                ByteBuffer bb = hdfFc.readBufferFromAddress(address, secondaryBlockSize);
                ExtensibleArrayIndex.this.verifySignature(bb, EXTENSIBLE_ARRAY_SECONDARY_BLOCK_SIGNATURE);
                byte version = bb.get();
                if (version != 0) {
                    throw new HdfException("Unsupported fixed array data block version detected. Version: " + version);
                }
                byte clientId = bb.get();
                if (clientId != ExtensibleArrayIndex.this.clientId) {
                    throw new HdfException("Extensible array client ID mismatch. Possible file corruption detected");
                }
                long headerAddress = Utils.readBytesAsUnsignedLong(bb, hdfFc.getSizeOfOffsets());
                if (headerAddress != ExtensibleArrayIndex.this.headerAddress) {
                    throw new HdfException("Extensible array secondary block header address mismatch");
                }
                long blockOffset = Utils.readBytesAsUnsignedLong(bb, ExtensibleArrayIndex.this.blockOffsetSize);
                for (int i = 0; i < numberOfPointers && (dataBlockAddress = Utils.readBytesAsUnsignedLong(bb, hdfFc.getSizeOfOffsets())) != -1L; ++i) {
                    new ExtensibleArrayDataBlock(hdfFc, dataBlockAddress);
                }
            }
        }

        private class ExtensibleArrayDataBlock {
            private ExtensibleArrayDataBlock(HdfFileChannel hdfFc, long address) {
                int numberOfElementsInDataBlock = ExtensibleArrayIndex.this.dataBlockElementCounter.getNextNumberOfChunks();
                int headerSize = 6 + hdfFc.getSizeOfOffsets() + ExtensibleArrayIndex.this.blockOffsetSize + numberOfElementsInDataBlock * ExtensibleArrayIndex.this.extensibleArrayElementSize + 4;
                ByteBuffer bb = hdfFc.readBufferFromAddress(address, headerSize);
                ExtensibleArrayIndex.this.verifySignature(bb, EXTENSIBLE_ARRAY_DATA_BLOCK_SIGNATURE);
                byte version = bb.get();
                if (version != 0) {
                    throw new HdfException("Unsupported extensible array data block version detected. Version: " + version);
                }
                byte clientId = bb.get();
                if (clientId != ExtensibleArrayIndex.this.clientId) {
                    throw new HdfException("Extensible array client ID mismatch. Possible file corruption detected");
                }
                long headerAddress = Utils.readBytesAsUnsignedLong(bb, hdfFc.getSizeOfOffsets());
                if (headerAddress != ExtensibleArrayIndex.this.headerAddress) {
                    throw new HdfException("Extensible array data block header address mismatch");
                }
                long blockOffset = Utils.readBytesAsUnsignedLong(bb, ExtensibleArrayIndex.this.blockOffsetSize);
                boolean readElement = true;
                for (int i = 0; readElement && i < numberOfElementsInDataBlock; ++i) {
                    readElement = ExtensibleArrayIndexBlock.this.readElement(bb, hdfFc);
                }
            }
        }
    }
}

