/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked;

import io.jhdf.HdfFileChannel;
import io.jhdf.ObjectHeader;
import io.jhdf.api.Group;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.ChunkOffset;
import io.jhdf.dataset.chunked.ChunkedDatasetBase;
import io.jhdf.dataset.chunked.DatasetInfo;
import io.jhdf.dataset.chunked.indexing.BTreeIndex;
import io.jhdf.dataset.chunked.indexing.ChunkIndex;
import io.jhdf.dataset.chunked.indexing.EmptyChunkIndex;
import io.jhdf.dataset.chunked.indexing.ExtensibleArrayIndex;
import io.jhdf.dataset.chunked.indexing.FixedArrayIndex;
import io.jhdf.dataset.chunked.indexing.SingleChunkIndex;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.message.DataLayoutMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedDatasetV4
extends ChunkedDatasetBase {
    private static final Logger logger = LoggerFactory.getLogger(ChunkedDatasetV4.class);
    private final DataLayoutMessage.ChunkedDataLayoutMessageV4 layoutMessage;
    private final ChunkLookupLazyInitializer chunkLookupLazyInitializer;

    public ChunkedDatasetV4(HdfFileChannel hdfFc, long address, String name, Group parent, ObjectHeader oh) {
        super(hdfFc, address, name, parent, oh);
        this.layoutMessage = oh.getMessageOfType(DataLayoutMessage.ChunkedDataLayoutMessageV4.class);
        this.chunkLookupLazyInitializer = new ChunkLookupLazyInitializer();
        logger.debug("Created chunked v4 dataset. Index type {}", (Object)this.layoutMessage.getIndexingType());
    }

    @Override
    public int[] getChunkDimensions() {
        int[] chunkDimensions = this.layoutMessage.getChunkDimensions();
        return ArrayUtils.subarray((int[])chunkDimensions, (int)0, (int)(chunkDimensions.length - 1));
    }

    @Override
    protected Map<ChunkOffset, Chunk> getChunkLookup() {
        try {
            return (Map)this.chunkLookupLazyInitializer.get();
        }
        catch (ConcurrentException e) {
            throw new HdfException("Failed to create chunk lookup for: " + this.getPath(), e);
        }
    }

    private final class ChunkLookupLazyInitializer
    extends LazyInitializer<Map<ChunkOffset, Chunk>> {
        private ChunkLookupLazyInitializer() {
        }

        protected Map<ChunkOffset, Chunk> initialize() {
            ChunkIndex chunkIndex;
            logger.debug("Creating chunk lookup for '{}'", (Object)ChunkedDatasetV4.this.getPath());
            DatasetInfo datasetInfo = new DatasetInfo(this.getChunkSizeInBytes(), ChunkedDatasetV4.this.getDimensions(), ChunkedDatasetV4.this.getChunkDimensions());
            if (ChunkedDatasetV4.this.layoutMessage.getAddress() == -1L) {
                logger.debug("No storage allocated for '{}'", (Object)ChunkedDatasetV4.this.getPath());
                chunkIndex = new EmptyChunkIndex();
            } else {
                switch (ChunkedDatasetV4.this.layoutMessage.getIndexingType()) {
                    case 1: {
                        logger.debug("Reading single chunk indexed dataset");
                        chunkIndex = new SingleChunkIndex(ChunkedDatasetV4.this.layoutMessage, datasetInfo);
                        break;
                    }
                    case 2: {
                        throw new UnsupportedHdfException("Implicit indexing is currently not supported");
                    }
                    case 3: {
                        logger.debug("Reading fixed array indexed dataset");
                        chunkIndex = new FixedArrayIndex(ChunkedDatasetV4.this.hdfFc, ChunkedDatasetV4.this.layoutMessage.getAddress(), datasetInfo);
                        break;
                    }
                    case 4: {
                        logger.debug("Reading extensible array indexed dataset");
                        chunkIndex = new ExtensibleArrayIndex(ChunkedDatasetV4.this.hdfFc, ChunkedDatasetV4.this.layoutMessage.getAddress(), datasetInfo);
                        break;
                    }
                    case 5: {
                        logger.debug("Reading B tree v2 indexed dataset");
                        chunkIndex = new BTreeIndex(ChunkedDatasetV4.this.hdfFc, ChunkedDatasetV4.this.layoutMessage.getAddress(), datasetInfo);
                        break;
                    }
                    default: {
                        throw new HdfException("Unrecognized chunk indexing type = " + ChunkedDatasetV4.this.layoutMessage.getIndexingType());
                    }
                }
            }
            Collection<Chunk> allChunks = chunkIndex.getAllChunks();
            return allChunks.stream().collect(Collectors.toMap(chunk -> new ChunkOffset(chunk.getChunkOffset()), Function.identity()));
        }

        private int getChunkSizeInBytes() {
            return Arrays.stream(ChunkedDatasetV4.this.getChunkDimensions()).reduce(1, Math::multiplyExact) * ChunkedDatasetV4.this.getDataType().getSize();
        }
    }
}

