/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.HdfFileChannel;
import io.jhdf.ObjectHeader;
import io.jhdf.api.Group;
import io.jhdf.api.dataset.ContiguousDataset;
import io.jhdf.dataset.DatasetBase;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.DataLayoutMessage;
import java.nio.ByteBuffer;

public class ContiguousDatasetImpl
extends DatasetBase
implements ContiguousDataset {
    public ContiguousDatasetImpl(HdfFileChannel hdfFc, long address, String name, Group parent, ObjectHeader oh) {
        super(hdfFc, address, name, parent, oh);
    }

    @Override
    public ByteBuffer getDataBuffer() {
        DataLayoutMessage.ContiguousDataLayoutMessage contiguousDataLayoutMessage = this.getHeaderMessage(DataLayoutMessage.ContiguousDataLayoutMessage.class);
        if (contiguousDataLayoutMessage.getAddress() == -1L) {
            return null;
        }
        try {
            ByteBuffer data = this.hdfFc.map(contiguousDataLayoutMessage.getAddress(), contiguousDataLayoutMessage.getSize());
            this.convertToCorrectEndiness(data);
            return data;
        }
        catch (Exception e) {
            throw new HdfException("Failed to map data buffer for dataset '" + this.getPath() + "'", e);
        }
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.getDataBuffer();
    }

    @Override
    public long getDataAddress() {
        DataLayoutMessage.ContiguousDataLayoutMessage contiguousDataLayoutMessage = this.getHeaderMessage(DataLayoutMessage.ContiguousDataLayoutMessage.class);
        return contiguousDataLayoutMessage.getAddress();
    }
}

