/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.HdfFileChannel;
import io.jhdf.dataset.DatasetReader;
import io.jhdf.object.datatype.CompoundDataType;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CompoundDatasetReader {
    private CompoundDatasetReader() {
    }

    public static Map<String, Object> readDataset(CompoundDataType type, ByteBuffer buffer, int[] dimensions, HdfFileChannel hdfFc) {
        int sizeAsInt = Arrays.stream(dimensions).reduce(1, Math::multiplyExact);
        List<CompoundDataType.CompoundDataMember> members = type.getMembers();
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(members.size());
        for (CompoundDataType.CompoundDataMember member : members) {
            byte[] memberBytes = new byte[member.getDataType().getSize()];
            ByteBuffer memberBuffer = ByteBuffer.allocate(member.getDataType().getSize() * sizeAsInt);
            for (int i = 0; i < sizeAsInt; ++i) {
                buffer.position(type.getSize() * i + member.getOffset());
                buffer.get(memberBytes, 0, memberBytes.length);
                memberBuffer.put(memberBytes);
            }
            memberBuffer.rewind();
            Object memberData = DatasetReader.readDataset(member.getDataType(), memberBuffer, dimensions, hdfFc);
            data.put(member.getName(), memberData);
        }
        return data;
    }
}

