/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.btree.BTreeV1;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class BTreeV1Group
extends BTreeV1 {
    private BTreeV1Group(HdfFileChannel hdfFc, long address) {
        super(hdfFc, address);
    }

    static class BTreeV1GroupNonLeafNode
    extends BTreeV1Group {
        private final List<BTreeV1> childNodes;

        BTreeV1GroupNonLeafNode(HdfFileChannel hdfFc, long address) {
            super(hdfFc, address);
            int keyBytes = (2 * this.entriesUsed + 1) * hdfFc.getSizeOfLengths();
            int childPointerBytes = 2 * this.entriesUsed * hdfFc.getSizeOfOffsets();
            int keysAndPointersBytes = keyBytes + childPointerBytes;
            long keysAddress = address + 8L + 2L * (long)hdfFc.getSizeOfOffsets();
            ByteBuffer keysAndPointersBuffer = hdfFc.readBufferFromAddress(keysAddress, keysAndPointersBytes);
            this.childNodes = new ArrayList<BTreeV1>(this.entriesUsed);
            for (int i = 0; i < this.entriesUsed; ++i) {
                keysAndPointersBuffer.position(keysAndPointersBuffer.position() + hdfFc.getSizeOfOffsets());
                long childAddress = Utils.readBytesAsUnsignedLong(keysAndPointersBuffer, hdfFc.getSizeOfOffsets());
                this.childNodes.add(BTreeV1GroupNonLeafNode.createGroupBTree(hdfFc, childAddress));
            }
        }

        @Override
        public List<Long> getChildAddresses() {
            ArrayList<Long> childAddresses = new ArrayList<Long>();
            for (BTreeV1 child : this.childNodes) {
                childAddresses.addAll(child.getChildAddresses());
            }
            return childAddresses;
        }
    }

    static class BTreeV1GroupLeafNode
    extends BTreeV1Group {
        private final List<Long> childAddresses;

        BTreeV1GroupLeafNode(HdfFileChannel hdfFc, long address) {
            super(hdfFc, address);
            int keyBytes = (2 * this.entriesUsed + 1) * hdfFc.getSizeOfLengths();
            int childPointerBytes = 2 * this.entriesUsed * hdfFc.getSizeOfOffsets();
            int keysAndPointersBytes = keyBytes + childPointerBytes;
            long keysAddress = address + 8L + 2L * (long)hdfFc.getSizeOfOffsets();
            ByteBuffer keysAndPointersBuffer = hdfFc.readBufferFromAddress(keysAddress, keysAndPointersBytes);
            this.childAddresses = new ArrayList<Long>(this.entriesUsed);
            for (int i = 0; i < this.entriesUsed; ++i) {
                keysAndPointersBuffer.position(keysAndPointersBuffer.position() + hdfFc.getSizeOfLengths());
                this.childAddresses.add(Utils.readBytesAsUnsignedLong(keysAndPointersBuffer, hdfFc.getSizeOfOffsets()));
            }
        }

        @Override
        public List<Long> getChildAddresses() {
            return this.childAddresses;
        }
    }
}

