/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree;

import io.jhdf.HdfFileChannel;
import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.btree.BTreeV1;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.indexing.ChunkImpl;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;

public abstract class BTreeV1Data
extends BTreeV1 {
    private BTreeV1Data(HdfFileChannel hdfFc, long address) {
        super(hdfFc, address);
    }

    public abstract List<Chunk> getChunks();

    static class BTreeV1DataNonLeafNode
    extends BTreeV1Data {
        private final List<BTreeV1Data> childNodes;

        BTreeV1DataNonLeafNode(HdfFileChannel hdfFc, long address, int dataDimensions) {
            super(hdfFc, address);
            int keySize = 8 + (dataDimensions + 1) * 8;
            int keyBytes = (this.entriesUsed + 1) * keySize;
            int childPointerBytes = this.entriesUsed * hdfFc.getSizeOfOffsets();
            int keysAndPointersBytes = keyBytes + childPointerBytes;
            long keysAddress = address + 8L + 2L * (long)hdfFc.getSizeOfOffsets();
            ByteBuffer keysAndPointersBuffer = hdfFc.readBufferFromAddress(keysAddress, keysAndPointersBytes);
            this.childNodes = new ArrayList<BTreeV1Data>(this.entriesUsed);
            for (int i = 0; i < this.entriesUsed; ++i) {
                keysAndPointersBuffer.position(keysAndPointersBuffer.position() + keySize);
                long childAddress = Utils.readBytesAsUnsignedLong(keysAndPointersBuffer, hdfFc.getSizeOfOffsets());
                this.childNodes.add(BTreeV1.createDataBTree(hdfFc, childAddress, dataDimensions));
            }
        }

        @Override
        public List<Chunk> getChunks() {
            ArrayList<Chunk> childAddresses = new ArrayList<Chunk>();
            for (BTreeV1Data child : this.childNodes) {
                childAddresses.addAll(child.getChunks());
            }
            return childAddresses;
        }

        @Override
        public List<Long> getChildAddresses() {
            ArrayList<Long> childAddresses = new ArrayList<Long>();
            for (BTreeV1 bTreeV1 : this.childNodes) {
                childAddresses.addAll(bTreeV1.getChildAddresses());
            }
            return childAddresses;
        }
    }

    static class BTreeV1DataLeafNode
    extends BTreeV1Data {
        private final ArrayList<Chunk> chunks;

        BTreeV1DataLeafNode(HdfFileChannel hdfFc, long address, int dataDimensions) {
            super(hdfFc, address);
            int keySize = 8 + (dataDimensions + 1) * 8;
            int keyBytes = (this.entriesUsed + 1) * keySize;
            int childPointerBytes = this.entriesUsed * hdfFc.getSizeOfOffsets();
            int keysAndPointersBytes = keyBytes + childPointerBytes;
            long keysAddress = address + 8L + 2L * (long)hdfFc.getSizeOfOffsets();
            ByteBuffer bb = hdfFc.readBufferFromAddress(keysAddress, keysAndPointersBytes);
            this.chunks = new ArrayList(this.entriesUsed);
            for (int i = 0; i < this.entriesUsed; ++i) {
                Chunk chunk = this.readKeyAsChunk(hdfFc.getSuperblock(), dataDimensions, bb);
                this.chunks.add(chunk);
            }
            bb.position(bb.position() + keySize);
        }

        private Chunk readKeyAsChunk(Superblock sb, int dataDimensions, ByteBuffer bb) {
            int chunkSize = Utils.readBytesAsUnsignedInt(bb, 4);
            BitSet filterMask = BitSet.valueOf(new byte[]{bb.get(), bb.get(), bb.get(), bb.get()});
            int[] chunkOffset = new int[dataDimensions];
            for (int j = 0; j < dataDimensions; ++j) {
                chunkOffset[j] = Utils.readBytesAsUnsignedInt(bb, 8);
            }
            long zero = Utils.readBytesAsUnsignedLong(bb, 8);
            if (zero != 0L) {
                throw new HdfException("Invalid B tree chunk detected");
            }
            long chunkAddress = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets());
            return new ChunkImpl(chunkAddress, chunkSize, chunkOffset, filterMask);
        }

        @Override
        public List<Long> getChildAddresses() {
            return this.chunks.stream().map(Chunk::getAddress).collect(Collectors.toList());
        }

        @Override
        public List<Chunk> getChunks() {
            return this.chunks;
        }
    }
}

