/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public final class Utils {
    private static final CharsetEncoder ASCII = StandardCharsets.US_ASCII.newEncoder();
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private Utils() {
    }

    public static String toHex(long address) {
        if (address == -1L) {
            return "UNDEFINED";
        }
        return "0x" + Long.toHexString(address);
    }

    public static String readUntilNull(ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder(buffer.remaining());
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b == 0) {
                return sb.toString();
            }
            sb.append((char)b);
        }
        throw new IllegalArgumentException("End of buffer reached before NULL");
    }

    public static boolean validateName(String name) {
        return ASCII.canEncode(name) && !name.contains("/") && !name.contains(".");
    }

    public static void seekBufferToNextMultipleOfEight(ByteBuffer bb) {
        int pos = bb.position();
        if (pos % 8 == 0) {
            return;
        }
        bb.position(pos + (8 - pos % 8));
    }

    public static int readBytesAsUnsignedInt(ByteBuffer buffer, int length) {
        switch (length) {
            case 1: {
                return Byte.toUnsignedInt(buffer.get());
            }
            case 2: {
                return Short.toUnsignedInt(buffer.getShort());
            }
            case 3: {
                return Utils.readArbitraryLengthBytesAsUnsignedInt(buffer, length);
            }
            case 4: {
                int value = buffer.getInt();
                if (value < 0) {
                    throw new ArithmeticException("Could not convert to unsigned");
                }
                return value;
            }
            case 5: 
            case 6: 
            case 7: {
                return Utils.readArbitraryLengthBytesAsUnsignedInt(buffer, length);
            }
            case 8: {
                return Math.toIntExact(buffer.getLong());
            }
        }
        throw new IllegalArgumentException("Couldn't read " + length + " bytes as int");
    }

    private static int readArbitraryLengthBytesAsUnsignedInt(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])bytes);
        }
        return new BigInteger(1, bytes).intValueExact();
    }

    public static long readBytesAsUnsignedLong(ByteBuffer buffer, int length) {
        switch (length) {
            case 1: {
                return Byte.toUnsignedLong(buffer.get());
            }
            case 2: {
                return Short.toUnsignedLong(buffer.getShort());
            }
            case 3: {
                return Utils.readArbitraryLengthBytesAsUnsignedLong(buffer, length);
            }
            case 4: {
                return Integer.toUnsignedLong(buffer.getInt());
            }
            case 5: 
            case 6: 
            case 7: {
                return Utils.readArbitraryLengthBytesAsUnsignedLong(buffer, length);
            }
            case 8: {
                long value = buffer.getLong();
                if (value < 0L && value != -1L) {
                    throw new ArithmeticException("Could not convert to unsigned");
                }
                return value;
            }
        }
        throw new IllegalArgumentException("Couldn't read " + length + " bytes as int");
    }

    private static long readArbitraryLengthBytesAsUnsignedLong(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])bytes);
        }
        return new BigInteger(1, bytes).longValueExact();
    }

    public static ByteBuffer createSubBuffer(ByteBuffer source, int length) {
        ByteBuffer headerData = source.slice();
        headerData.limit(length);
        headerData.order(source.order());
        source.position(source.position() + length);
        return headerData;
    }

    public static int bitsToInt(BitSet bits, int start, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length must be >0");
        }
        BigInteger result = BigInteger.ZERO;
        for (int i = 0; i < length; ++i) {
            if (!bits.get(start + i)) continue;
            result = result.add(TWO.pow(i));
        }
        return result.intValue();
    }

    public static int bytesNeededToHoldNumber(long number) {
        if (number < 0L) {
            throw new IllegalArgumentException("Only for unsigned numbers");
        }
        if (number == 0L) {
            return 1;
        }
        return (int)Math.ceil((double)BigInteger.valueOf(number).bitLength() / 8.0);
    }

    public static int[] linearIndexToDimensionIndex(int index, int[] dimensions) {
        int[] dimIndex = new int[dimensions.length];
        for (int i = dimIndex.length - 1; i >= 0; --i) {
            dimIndex[i] = index % dimensions[i];
            index /= dimensions[i];
        }
        return dimIndex;
    }

    public static int dimensionIndexToLinearIndex(int[] index, int[] dimensions) {
        int linear = 0;
        for (int i = 0; i < dimensions.length; ++i) {
            int temp = index[i];
            for (int j = i + 1; j < dimensions.length; ++j) {
                temp *= dimensions[j];
            }
            linear += temp;
        }
        return linear;
    }

    public static int[] chunkIndexToChunkOffset(int chunkIndex, int[] chunkDimensions, int[] datasetDimensions) {
        int[] chunkOffset = new int[chunkDimensions.length];
        for (int i = 0; i < chunkOffset.length; ++i) {
            int chunksBelowThisDim = 1;
            for (int j = i + 1; j < chunkOffset.length; ++j) {
                chunksBelowThisDim *= (int)Math.ceil((double)datasetDimensions[j] / (double)chunkDimensions[j]);
            }
            chunkOffset[i] = chunkIndex / chunksBelowThisDim * chunkDimensions[i];
            chunkIndex -= chunkOffset[i] / chunkDimensions[i] * chunksBelowThisDim;
        }
        return chunkOffset;
    }

    public static int[] stripLeadingIndex(int[] dims) {
        return Arrays.copyOfRange(dims, 1, dims.length);
    }
}

