/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Superblock {
    private static final Logger logger = LoggerFactory.getLogger(Superblock.class);
    private static final byte[] HDF5_FILE_SIGNATURE = new byte[]{-119, 72, 68, 70, 13, 10, 26, 10};
    private static final int HDF5_FILE_SIGNATURE_LENGTH = HDF5_FILE_SIGNATURE.length;

    public abstract int getVersionOfSuperblock();

    public abstract int getSizeOfOffsets();

    public abstract int getSizeOfLengths();

    public abstract long getBaseAddressByte();

    public abstract long getEndOfFileAddress();

    static boolean verifySignature(FileChannel fc, long offset) {
        ByteBuffer signatureBuffer = ByteBuffer.allocate(HDF5_FILE_SIGNATURE_LENGTH);
        try {
            fc.read(signatureBuffer, offset);
        }
        catch (IOException e) {
            throw new HdfException("Failed to read from address: " + Utils.toHex(offset), e);
        }
        return Arrays.equals(HDF5_FILE_SIGNATURE, signatureBuffer.array());
    }

    public static Superblock readSuperblock(FileChannel fc, long address) {
        boolean verifiedSignature = Superblock.verifySignature(fc, address);
        if (!verifiedSignature) {
            throw new HdfException("Superblock didn't contain valid signature");
        }
        logger.trace("Verified superblock signature");
        long fileLocation = address + (long)HDF5_FILE_SIGNATURE_LENGTH;
        ByteBuffer version = ByteBuffer.allocate(1);
        try {
            fc.read(version, fileLocation);
        }
        catch (IOException e) {
            throw new HdfException("Failed to read superblock at address = " + Utils.toHex(address));
        }
        version.rewind();
        byte versionOfSuperblock = version.get();
        logger.debug("Version of superblock is = {}", (Object)versionOfSuperblock);
        switch (versionOfSuperblock) {
            case 0: 
            case 1: {
                return new SuperblockV0V1(fc, fileLocation);
            }
            case 2: 
            case 3: {
                return new SuperblockV2V3(fc, fileLocation);
            }
        }
        throw new UnsupportedHdfException("Superblock version is not supported. Detected version = " + versionOfSuperblock);
    }

    public static class SuperblockV2V3
    extends Superblock {
        private final int versionOfSuperblock;
        private final int sizeOfOffsets;
        private final int sizeOfLengths;
        private final long baseAddressByte;
        private final long superblockExtensionAddress;
        private final long endOfFileAddress;
        private final long rootGroupObjectHeaderAddress;

        private SuperblockV2V3(FileChannel fc, long address) {
            try {
                ByteBuffer header = ByteBuffer.allocate(4);
                fc.read(header, address);
                address += 4L;
                header.order(ByteOrder.LITTLE_ENDIAN);
                header.rewind();
                this.versionOfSuperblock = header.get();
                logger.trace("Version of superblock is = {}", (Object)this.versionOfSuperblock);
                this.sizeOfOffsets = Byte.toUnsignedInt(header.get());
                logger.trace("Size of Offsets: {}", (Object)this.sizeOfOffsets);
                this.sizeOfLengths = Byte.toUnsignedInt(header.get());
                logger.trace("Size of Lengths: {}", (Object)this.sizeOfLengths);
                int nextSectionSize = 4 * this.sizeOfOffsets + 4;
                header = ByteBuffer.allocate(nextSectionSize);
                fc.read(header, address);
                address += (long)nextSectionSize;
                header.order(ByteOrder.LITTLE_ENDIAN);
                header.rewind();
                this.baseAddressByte = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
                logger.trace("baseAddressByte = {}", (Object)this.baseAddressByte);
                this.superblockExtensionAddress = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
                logger.trace("addressOfGlobalFreeSpaceIndex = {}", (Object)this.superblockExtensionAddress);
                if (this.superblockExtensionAddress != -1L) {
                    throw new UnsupportedHdfException("Superblock extension is not supported");
                }
                this.endOfFileAddress = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
                logger.trace("endOfFileAddress = {}", (Object)this.endOfFileAddress);
                this.rootGroupObjectHeaderAddress = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
                logger.trace("rootGroupObjectHeaderAddress= {}", (Object)this.rootGroupObjectHeaderAddress);
            }
            catch (IOException e) {
                throw new HdfException("Failed to read superblock from address " + Utils.toHex(address), e);
            }
        }

        @Override
        public int getVersionOfSuperblock() {
            return this.versionOfSuperblock;
        }

        @Override
        public int getSizeOfOffsets() {
            return this.sizeOfOffsets;
        }

        @Override
        public int getSizeOfLengths() {
            return this.sizeOfLengths;
        }

        @Override
        public long getBaseAddressByte() {
            return this.baseAddressByte;
        }

        public long getSuperblockExtensionAddress() {
            return this.superblockExtensionAddress;
        }

        @Override
        public long getEndOfFileAddress() {
            return this.endOfFileAddress;
        }

        public long getRootGroupObjectHeaderAddress() {
            return this.rootGroupObjectHeaderAddress;
        }
    }

    public static class SuperblockV0V1
    extends Superblock {
        private final int versionOfSuperblock;
        private final int versionNumberOfTheFileFreeSpaceInformation;
        private final int versionOfRootGroupSymbolTableEntry;
        private final int versionOfSharedHeaderMessageFormat;
        private final int sizeOfOffsets;
        private final int sizeOfLengths;
        private final int groupLeafNodeK;
        private final int groupInternalNodeK;
        private final long baseAddressByte;
        private final long addressOfGlobalFreeSpaceIndex;
        private final long endOfFileAddress;
        private final long driverInformationBlockAddress;
        private final long rootGroupSymbolTableAddress;

        private SuperblockV0V1(FileChannel fc, long address) {
            try {
                ByteBuffer header = ByteBuffer.allocate(12);
                fc.read(header, address);
                address += 12L;
                header.order(ByteOrder.LITTLE_ENDIAN);
                header.rewind();
                this.versionOfSuperblock = header.get();
                logger.trace("Version of superblock is = {}", (Object)this.versionOfSuperblock);
                if (this.versionOfSuperblock != 0 && this.versionOfSuperblock != 1) {
                    throw new HdfException("Detected superblock version not 0 or 1");
                }
                this.versionNumberOfTheFileFreeSpaceInformation = header.get();
                logger.trace("Version Number of the File Free-Space Information: {}", (Object)this.versionNumberOfTheFileFreeSpaceInformation);
                this.versionOfRootGroupSymbolTableEntry = header.get();
                logger.trace("Version # of Root Group Symbol Table Entry: {}", (Object)this.versionOfRootGroupSymbolTableEntry);
                header.position(header.position() + 1);
                this.versionOfSharedHeaderMessageFormat = header.get();
                logger.trace("Version # of Shared Header Message Format: {}", (Object)this.versionOfSharedHeaderMessageFormat);
                this.sizeOfOffsets = Byte.toUnsignedInt(header.get());
                logger.trace("Size of Offsets: {}", (Object)this.sizeOfOffsets);
                this.sizeOfLengths = Byte.toUnsignedInt(header.get());
                logger.trace("Size of Lengths: {}", (Object)this.sizeOfLengths);
                header.position(header.position() + 1);
                this.groupLeafNodeK = Short.toUnsignedInt(header.getShort());
                logger.trace("groupLeafNodeK = {}", (Object)this.groupLeafNodeK);
                this.groupInternalNodeK = Short.toUnsignedInt(header.getShort());
                logger.trace("groupInternalNodeK = {}", (Object)this.groupInternalNodeK);
                address += 4L;
                if (this.versionOfSuperblock == 1) {
                    address += 4L;
                }
                int nextSectionSize = 4 * this.sizeOfOffsets;
                header = ByteBuffer.allocate(nextSectionSize);
                fc.read(header, address);
                address += (long)nextSectionSize;
                header.order(ByteOrder.LITTLE_ENDIAN);
                header.rewind();
                this.baseAddressByte = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
                logger.trace("baseAddressByte = {}", (Object)this.baseAddressByte);
                this.addressOfGlobalFreeSpaceIndex = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
                logger.trace("addressOfGlobalFreeSpaceIndex = {}", (Object)this.addressOfGlobalFreeSpaceIndex);
                this.endOfFileAddress = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
                logger.trace("endOfFileAddress = {}", (Object)this.endOfFileAddress);
                this.driverInformationBlockAddress = Utils.readBytesAsUnsignedLong(header, this.sizeOfOffsets);
                logger.trace("driverInformationBlockAddress = {}", (Object)this.driverInformationBlockAddress);
                this.rootGroupSymbolTableAddress = address;
                logger.trace("rootGroupSymbolTableAddress= {}", (Object)this.rootGroupSymbolTableAddress);
            }
            catch (IOException e) {
                throw new HdfException("Failed to read superblock from address " + Utils.toHex(address), e);
            }
        }

        @Override
        public int getVersionOfSuperblock() {
            return this.versionOfSuperblock;
        }

        public int getVersionNumberOfTheFileFreeSpaceInformation() {
            return this.versionNumberOfTheFileFreeSpaceInformation;
        }

        public int getVersionOfRootGroupSymbolTableEntry() {
            return this.versionOfRootGroupSymbolTableEntry;
        }

        public int getVersionOfSharedHeaderMessageFormat() {
            return this.versionOfSharedHeaderMessageFormat;
        }

        @Override
        public int getSizeOfOffsets() {
            return this.sizeOfOffsets;
        }

        @Override
        public int getSizeOfLengths() {
            return this.sizeOfLengths;
        }

        public int getGroupLeafNodeK() {
            return this.groupLeafNodeK;
        }

        public int getGroupInternalNodeK() {
            return this.groupInternalNodeK;
        }

        @Override
        public long getBaseAddressByte() {
            return this.baseAddressByte;
        }

        public long getAddressOfGlobalFreeSpaceIndex() {
            return this.addressOfGlobalFreeSpaceIndex;
        }

        @Override
        public long getEndOfFileAddress() {
            return this.endOfFileAddress;
        }

        public long getDriverInformationBlockAddress() {
            return this.driverInformationBlockAddress;
        }

        public long getRootGroupSymbolTableAddress() {
            return this.rootGroupSymbolTableAddress;
        }
    }
}

