/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.GroupImpl;
import io.jhdf.HdfFileChannel;
import io.jhdf.Superblock;
import io.jhdf.SymbolTableEntry;
import io.jhdf.api.Attribute;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.api.NodeType;
import io.jhdf.exceptions.HdfException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfFile
implements Group,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(HdfFile.class);
    private final File file;
    private final HdfFileChannel hdfFc;
    private final Group rootGroup;
    private final Set<HdfFile> openExternalFiles;

    public HdfFile(Path path) {
        this(path.toFile());
    }

    public HdfFile(URI uri) {
        this(Paths.get(uri).toFile());
    }

    public HdfFile(File hdfFile) {
        block8: {
            this.openExternalFiles = new HashSet<HdfFile>();
            logger.info("Opening HDF5 file '{}'...", (Object)hdfFile.getAbsolutePath());
            this.file = hdfFile;
            try {
                FileChannel fc = FileChannel.open(hdfFile.toPath(), StandardOpenOption.READ);
                boolean validSignature = false;
                long offset = 0L;
                while (offset < fc.size()) {
                    logger.trace("Checking for signature at offset = {}", (Object)offset);
                    validSignature = Superblock.verifySignature(fc, offset);
                    if (validSignature) {
                        logger.debug("Found valid signature at offset = {}", (Object)offset);
                        break;
                    }
                    offset = this.nextOffset(offset);
                }
                if (!validSignature) {
                    throw new HdfException("No valid HDF5 signature found");
                }
                Superblock superblock = Superblock.readSuperblock(fc, offset);
                if (superblock.getBaseAddressByte() != offset) {
                    throw new HdfException("Invalid superblock base address detected");
                }
                this.hdfFc = new HdfFileChannel(fc, superblock);
                if (superblock instanceof Superblock.SuperblockV0V1) {
                    Superblock.SuperblockV0V1 sb = (Superblock.SuperblockV0V1)superblock;
                    SymbolTableEntry ste = new SymbolTableEntry(this.hdfFc, sb.getRootGroupSymbolTableAddress() - sb.getBaseAddressByte());
                    this.rootGroup = GroupImpl.createRootGroup(this.hdfFc, ste.getObjectHeaderAddress(), this);
                    break block8;
                }
                if (superblock instanceof Superblock.SuperblockV2V3) {
                    Superblock.SuperblockV2V3 sb = (Superblock.SuperblockV2V3)superblock;
                    this.rootGroup = GroupImpl.createRootGroup(this.hdfFc, sb.getRootGroupObjectHeaderAddress(), this);
                    break block8;
                }
                throw new HdfException("Unrecognized superblock version = " + superblock.getVersionOfSuperblock());
            }
            catch (IOException e) {
                throw new HdfException("Failed to open file '" + this.file.getAbsolutePath() + "' . Is it a HDF5 file?", e);
            }
        }
        logger.info("Opened HDF5 file '{}'", (Object)hdfFile.getAbsolutePath());
    }

    private long nextOffset(long offset) {
        if (offset == 0L) {
            return 512L;
        }
        return offset * 2L;
    }

    public long getUserBlockSize() {
        return this.hdfFc.getUserBlockSize();
    }

    public ByteBuffer getUserBlockBuffer() {
        return this.hdfFc.mapNoOffset(0L, this.hdfFc.getUserBlockSize());
    }

    @Override
    public void close() {
        for (HdfFile externalHdfFile : this.openExternalFiles) {
            externalHdfFile.close();
            logger.info("Closed external file '{}'", (Object)externalHdfFile.getFile().getAbsolutePath());
        }
        this.hdfFc.close();
        logger.info("Closed HDF file '{}'", (Object)this.getFile().getAbsolutePath());
    }

    public long size() {
        return this.hdfFc.size();
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public Map<String, Node> getChildren() {
        return this.rootGroup.getChildren();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPath() {
        return "/";
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.rootGroup.getAttributes();
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.rootGroup.getAttribute(name);
    }

    public String toString() {
        return "HdfFile [file=" + this.file.getName() + "]";
    }

    @Override
    public NodeType getType() {
        return NodeType.FILE;
    }

    @Override
    public Group getParent() {
        return null;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getAddress() {
        return this.rootGroup.getAddress();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.rootGroup.iterator();
    }

    @Override
    public Node getChild(String name) {
        return this.rootGroup.getChild(name);
    }

    @Override
    public Node getByPath(String path) {
        path = StringUtils.stripStart((String)path, (String)"/");
        return this.rootGroup.getByPath(path);
    }

    @Override
    public Dataset getDatasetByPath(String path) {
        path = StringUtils.stripStart((String)path, (String)"/");
        return this.rootGroup.getDatasetByPath(path);
    }

    @Override
    public HdfFile getHdfFile() {
        return this;
    }

    public void addExternalFile(HdfFile hdfFile) {
        this.openExternalFiles.add(hdfFile);
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public boolean isAttributeCreationOrderTracked() {
        return this.rootGroup.isAttributeCreationOrderTracked();
    }

    @Override
    public boolean isLinkCreationOrderTracked() {
        return this.rootGroup.isLinkCreationOrderTracked();
    }

    public HdfFileChannel getHdfChannel() {
        return this.hdfFc;
    }

    static {
        String versionStr = HdfFile.class.getPackage().getImplementationVersion();
        if (versionStr != null) {
            logger.info("jHDF version: {}", (Object)HdfFile.class.getPackage().getImplementationVersion());
        } else {
            logger.warn("Using development version of jHDF");
        }
    }
}

