/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFileChannel;
import io.jhdf.SymbolTableEntry;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupSymbolTableNode {
    private static final Logger logger = LoggerFactory.getLogger(GroupSymbolTableNode.class);
    private static final byte[] NODE_SIGNATURE = "SNOD".getBytes(StandardCharsets.US_ASCII);
    private final long address;
    private final short version;
    private final short numberOfEntries;
    private final SymbolTableEntry[] symbolTableEntries;

    public GroupSymbolTableNode(HdfFileChannel hdfFc, long address) {
        this.address = address;
        try {
            int headerSize = 8;
            ByteBuffer header = hdfFc.readBufferFromAddress(address, headerSize);
            byte[] formatSignatureBytes = new byte[4];
            header.get(formatSignatureBytes, 0, formatSignatureBytes.length);
            if (!Arrays.equals(NODE_SIGNATURE, formatSignatureBytes)) {
                throw new HdfException("Group symbol table Node signature not matched");
            }
            this.version = header.get();
            header.position(6);
            byte[] twoBytes = new byte[2];
            header.get(twoBytes);
            this.numberOfEntries = ByteBuffer.wrap(twoBytes).order(ByteOrder.LITTLE_ENDIAN).getShort();
            logger.trace("numberOfSymbols = {}", (Object)this.numberOfEntries);
            long symbolTableEntryBytes = (long)hdfFc.getSizeOfOffsets() * 2L + 8L + 16L;
            this.symbolTableEntries = new SymbolTableEntry[this.numberOfEntries];
            for (int i = 0; i < this.numberOfEntries; ++i) {
                long offset = address + (long)headerSize + (long)i * symbolTableEntryBytes;
                this.symbolTableEntries[i] = new SymbolTableEntry(hdfFc, offset);
            }
        }
        catch (Exception e) {
            throw new HdfException("Error reading Group symbol table node", e);
        }
    }

    public short getVersion() {
        return this.version;
    }

    public short getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public SymbolTableEntry[] getSymbolTableEntries() {
        return (SymbolTableEntry[])ArrayUtils.clone((Object[])this.symbolTableEntries);
    }

    public String toString() {
        return "GroupSymbolTableNode [address=" + this.address + ", numberOfEntries=" + this.numberOfEntries + "]";
    }
}

