/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GlobalHeap {
    private static final byte[] GLOBAL_HEAP_SIGNATURE = "GCOL".getBytes(StandardCharsets.US_ASCII);
    private final HdfFileChannel hdfFc;
    private final long address;
    private final Map<Integer, GlobalHeapObject> objects = new HashMap<Integer, GlobalHeapObject>();

    public GlobalHeap(HdfFileChannel hdfFc, long address) {
        this.hdfFc = hdfFc;
        this.address = address;
        try {
            int headerSize = 8 + hdfFc.getSizeOfLengths();
            ByteBuffer bb = hdfFc.readBufferFromAddress(address, headerSize);
            byte[] signatureBytes = new byte[4];
            bb.get(signatureBytes, 0, signatureBytes.length);
            if (!Arrays.equals(GLOBAL_HEAP_SIGNATURE, signatureBytes)) {
                throw new HdfException("Global heap signature 'GCOL' not matched, at address " + address);
            }
            byte version = bb.get();
            if (version != 1) {
                throw new HdfException("Unsupported global heap version detected. Version: " + version);
            }
            bb.position(8);
            int collectionSize = Utils.readBytesAsUnsignedInt(bb, hdfFc.getSizeOfLengths());
            int remainingCollectionSize = collectionSize - 8 - hdfFc.getSizeOfLengths();
            bb = hdfFc.readBufferFromAddress(address + (long)headerSize, remainingCollectionSize);
            while (bb.remaining() >= 16) {
                GlobalHeapObject object = new GlobalHeapObject(this, bb);
                if (object.index != 0) {
                    this.objects.put(object.index, object);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new HdfException("Error reading global heap at address " + address, e);
        }
    }

    public String toString() {
        return "GlobalHeap [address=" + this.address + ", objects=" + this.objects.size() + "]";
    }

    public ByteBuffer getObjectData(int index) {
        if (!this.objects.containsKey(index)) {
            throw new IllegalArgumentException("Global heap doesn't contain object with index: " + index);
        }
        return this.objects.get((Object)Integer.valueOf((int)index)).data.slice();
    }

    public int getObjectReferenceCount(int index) {
        if (!this.objects.containsKey(index)) {
            throw new IllegalArgumentException("Global heap doesn't contain object with index: " + index);
        }
        return this.objects.get((Object)Integer.valueOf((int)index)).referenceCount;
    }

    private static class GlobalHeapObject {
        final int index;
        final int referenceCount;
        final ByteBuffer data;

        private GlobalHeapObject(GlobalHeap globalHeap, ByteBuffer bb) {
            this.index = Utils.readBytesAsUnsignedInt(bb, 2);
            this.referenceCount = Utils.readBytesAsUnsignedInt(bb, 2);
            bb.position(bb.position() + 4);
            int size = Utils.readBytesAsUnsignedInt(bb, globalHeap.hdfFc.getSizeOfOffsets());
            if (this.index == 0) {
                size = size - 2 - 2 - 4 - globalHeap.hdfFc.getSizeOfOffsets();
            }
            this.data = Utils.createSubBuffer(bb, size);
            Utils.seekBufferToNextMultipleOfEight(bb);
        }
    }
}

