/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFileChannel;
import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.btree.BTreeV2;
import io.jhdf.btree.record.HugeFractalHeapObjectUnfilteredRecord;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FractalHeap {
    private static final Logger logger = LoggerFactory.getLogger(FractalHeap.class);
    private static final byte[] FRACTAL_HEAP_SIGNATURE = "FRHP".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] INDIRECT_BLOCK_SIGNATURE = "FHIB".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] DIRECT_BLOCK_SIGNATURE = "FHDB".getBytes(StandardCharsets.US_ASCII);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final long address;
    private final HdfFileChannel hdfFc;
    private final Superblock sb;
    private final int maxDirectBlockSize;
    private final long maxSizeOfManagedObjects;
    private final int idLength;
    private final int ioFiltersLength;
    private final int currentRowsInRootIndirectBlock;
    private final int startingRowsInRootIndirectBlock;
    private final int startingBlockSize;
    private final int tableWidth;
    private final long numberOfTinyObjectsInHeap;
    private final long sizeOfTinyObjectsInHeap;
    private final long numberOfHugeObjectsInHeap;
    private final long sizeOfHugeObjectsInHeap;
    private final long numberOfManagedObjectsInHeap;
    private final long offsetOfDirectBlockAllocationIteratorInManagedSpace;
    private final long amountOfAllocatedManagedSpaceInHeap;
    private final long amountOfManagedSpaceInHeap;
    private final long addressOfManagedBlocksFreeSpaceManager;
    private final long freeSpaceInManagedBlocks;
    private final long bTreeAddressOfHugeObjects;
    private final long nextHugeObjectId;
    private final BitSet flags;
    private int blockIndex = 0;
    private final NavigableMap<Long, DirectBlock> directBlocks = new TreeMap<Long, DirectBlock>();
    private final int bytesToStoreOffset;
    private final int bytesToStoreLength;

    public FractalHeap(HdfFileChannel hdfFc, long address) {
        this.hdfFc = hdfFc;
        this.sb = hdfFc.getSuperblock();
        this.address = address;
        int headerSize = 14 + 12 * this.sb.getSizeOfLengths() + 3 * this.sb.getSizeOfOffsets() + 2 + 2 + 2 + 2;
        ByteBuffer bb = hdfFc.readBufferFromAddress(address, headerSize);
        byte[] formatSignatureBytes = new byte[4];
        bb.get(formatSignatureBytes, 0, formatSignatureBytes.length);
        if (!Arrays.equals(FRACTAL_HEAP_SIGNATURE, formatSignatureBytes)) {
            throw new HdfException("Fractal heap signature 'FRHP' not matched, at address " + address);
        }
        byte version = bb.get();
        if (version != 0) {
            throw new HdfException("Unsupported fractal heap version detected. Version: " + version);
        }
        this.idLength = Utils.readBytesAsUnsignedInt(bb, 2);
        this.ioFiltersLength = Utils.readBytesAsUnsignedInt(bb, 2);
        this.flags = BitSet.valueOf(new byte[]{bb.get()});
        this.maxSizeOfManagedObjects = Utils.readBytesAsUnsignedLong(bb, 4);
        this.nextHugeObjectId = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfLengths());
        this.bTreeAddressOfHugeObjects = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfOffsets());
        this.freeSpaceInManagedBlocks = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfLengths());
        this.addressOfManagedBlocksFreeSpaceManager = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfOffsets());
        this.amountOfManagedSpaceInHeap = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfLengths());
        this.amountOfAllocatedManagedSpaceInHeap = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfLengths());
        this.offsetOfDirectBlockAllocationIteratorInManagedSpace = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfLengths());
        this.numberOfManagedObjectsInHeap = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfLengths());
        this.sizeOfHugeObjectsInHeap = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfLengths());
        this.numberOfHugeObjectsInHeap = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfLengths());
        this.sizeOfTinyObjectsInHeap = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfLengths());
        this.numberOfTinyObjectsInHeap = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfLengths());
        this.tableWidth = Utils.readBytesAsUnsignedInt(bb, 2);
        this.startingBlockSize = Utils.readBytesAsUnsignedInt(bb, this.sb.getSizeOfLengths());
        this.maxDirectBlockSize = Utils.readBytesAsUnsignedInt(bb, this.sb.getSizeOfLengths());
        int maxHeapSize = Utils.readBytesAsUnsignedInt(bb, 2);
        this.bytesToStoreOffset = (int)Math.ceil((double)maxHeapSize / 8.0);
        this.bytesToStoreLength = Utils.bytesNeededToHoldNumber(Math.min((long)this.maxDirectBlockSize, this.maxSizeOfManagedObjects));
        this.startingRowsInRootIndirectBlock = Utils.readBytesAsUnsignedInt(bb, 2);
        long addressOfRootBlock = Utils.readBytesAsUnsignedLong(bb, this.sb.getSizeOfOffsets());
        this.currentRowsInRootIndirectBlock = Utils.readBytesAsUnsignedInt(bb, 2);
        if (this.ioFiltersLength > 0) {
            throw new UnsupportedHdfException("IO filters are currently not supported");
        }
        if (addressOfRootBlock != -1L) {
            if (this.currentRowsInRootIndirectBlock == 0) {
                DirectBlock db = new DirectBlock(addressOfRootBlock);
                this.directBlocks.put(db.blockOffset, db);
            } else {
                IndirectBlock indirectBlock = new IndirectBlock(addressOfRootBlock);
                Iterator iterator = indirectBlock.childBlockAddresses.iterator();
                while (iterator.hasNext()) {
                    int blockSize;
                    long directBlockAddress = (Long)iterator.next();
                    if ((blockSize = this.getSizeOfDirectBlock(this.blockIndex++)) != -1) {
                        DirectBlock db = new DirectBlock(directBlockAddress);
                        this.directBlocks.put(db.getBlockOffset(), db);
                        continue;
                    }
                    new IndirectBlock(address);
                }
            }
        }
        logger.debug("Read fractal heap at address {}, loaded {} direct blocks", (Object)address, (Object)this.directBlocks.size());
    }

    public ByteBuffer getId(ByteBuffer buffer) {
        if (buffer.remaining() != this.idLength) {
            throw new HdfException("ID length is incorrect accessing fractal heap at address " + this.address + ". IDs should be " + this.idLength + " bytes but was " + buffer.capacity() + " bytes.");
        }
        BitSet idFlags = BitSet.valueOf(new byte[]{buffer.get()});
        int version = Utils.bitsToInt(idFlags, 6, 2);
        if (version != 0) {
            throw new HdfException("Unsupported btree v2 ID version detected. Version: " + version);
        }
        int type = Utils.bitsToInt(idFlags, 4, 2);
        switch (type) {
            case 0: {
                long offset = Utils.readBytesAsUnsignedLong(buffer, this.bytesToStoreOffset);
                int length = Utils.readBytesAsUnsignedInt(buffer, this.bytesToStoreLength);
                logger.debug("Getting ID at offset={} length={}", (Object)offset, (Object)length);
                Map.Entry<Long, DirectBlock> entry = this.directBlocks.floorEntry(offset);
                ByteBuffer bb = entry.getValue().getData();
                bb.order(ByteOrder.LITTLE_ENDIAN);
                bb.position(Math.toIntExact(offset - entry.getKey()));
                return Utils.createSubBuffer(bb, length);
            }
            case 1: {
                if (this.bTreeAddressOfHugeObjects <= 0L) {
                    throw new UnsupportedHdfException("Huge objects without BTreev2 are currently not supported");
                }
                BTreeV2 hugeObjectBTree = new BTreeV2(this.hdfFc, this.bTreeAddressOfHugeObjects);
                if (hugeObjectBTree.getRecords().size() != 1) {
                    throw new UnsupportedHdfException("Only Huge objects BTrees with 1 record are currently supported");
                }
                HugeFractalHeapObjectUnfilteredRecord ho = (HugeFractalHeapObjectUnfilteredRecord)hugeObjectBTree.getRecords().get(0);
                return this.hdfFc.readBufferFromAddress(ho.getAddress(), (int)ho.getLength());
            }
            case 2: {
                throw new UnsupportedHdfException("Tiny objects are currently not supported");
            }
        }
        throw new HdfException("Unrecognized ID type, type=" + type);
    }

    private int getSizeOfDirectBlock(int blockIndex) {
        int row = blockIndex / this.tableWidth;
        if (row < 2) {
            return this.startingBlockSize;
        }
        int size = this.startingBlockSize * TWO.pow(row - 1).intValueExact();
        if (size < this.maxDirectBlockSize) {
            return size;
        }
        return -1;
    }

    public String toString() {
        return "FractalHeap [address=" + this.address + ", idLength=" + this.idLength + ", numberOfTinyObjectsInHeap=" + this.numberOfTinyObjectsInHeap + ", numberOfHugeObjectsInHeap=" + this.numberOfHugeObjectsInHeap + ", numberOfManagedObjectsInHeap=" + this.numberOfManagedObjectsInHeap + "]";
    }

    public long getAddress() {
        return this.address;
    }

    public int getMaxDirectBlockSize() {
        return this.maxDirectBlockSize;
    }

    public long getMaxSizeOfManagedObjects() {
        return this.maxSizeOfManagedObjects;
    }

    public int getIdLength() {
        return this.idLength;
    }

    public int getIoFiltersLength() {
        return this.ioFiltersLength;
    }

    public int getStartingRowsInRootIndirectBlock() {
        return this.startingRowsInRootIndirectBlock;
    }

    public long getNumberOfTinyObjectsInHeap() {
        return this.numberOfTinyObjectsInHeap;
    }

    public long getSizeOfTinyObjectsInHeap() {
        return this.sizeOfTinyObjectsInHeap;
    }

    public long getNumberOfHugeObjectsInHeap() {
        return this.numberOfHugeObjectsInHeap;
    }

    public long getSizeOfHugeObjectsInHeap() {
        return this.sizeOfHugeObjectsInHeap;
    }

    public long getNumberOfManagedObjectsInHeap() {
        return this.numberOfManagedObjectsInHeap;
    }

    public long getOffsetOfDirectBlockAllocationIteratorInManagedSpace() {
        return this.offsetOfDirectBlockAllocationIteratorInManagedSpace;
    }

    public long getAmountOfAllocatedManagedSpaceInHeap() {
        return this.amountOfAllocatedManagedSpaceInHeap;
    }

    public long getAmountOfManagedSpaceInHeap() {
        return this.amountOfManagedSpaceInHeap;
    }

    public long getAddressOfManagedBlocksFreeSpaceManager() {
        return this.addressOfManagedBlocksFreeSpaceManager;
    }

    public long getFreeSpaceInManagedBlocks() {
        return this.freeSpaceInManagedBlocks;
    }

    public long getBTreeAddressOfHugeObjects() {
        return this.bTreeAddressOfHugeObjects;
    }

    public long getNextHugeObjectId() {
        return this.nextHugeObjectId;
    }

    private class DirectBlock {
        private static final int CHECKSUM_PRESENT_BIT = 1;
        private final long address;
        private final ByteBuffer data;
        private final long blockOffset;

        private DirectBlock(long address) {
            this.address = address;
            int headerSize = 5 + FractalHeap.this.sb.getSizeOfOffsets() + FractalHeap.this.bytesToStoreOffset + 4;
            ByteBuffer bb = FractalHeap.this.hdfFc.readBufferFromAddress(address, headerSize);
            byte[] formatSignatureBytes = new byte[4];
            bb.get(formatSignatureBytes, 0, formatSignatureBytes.length);
            if (!Arrays.equals(DIRECT_BLOCK_SIGNATURE, formatSignatureBytes)) {
                throw new HdfException("Fractal heap direct block signature 'FHDB' not matched, at address " + address);
            }
            byte directBlockVersion = bb.get();
            if (directBlockVersion != 0) {
                throw new HdfException("Unsupported direct block version detected. Version: " + directBlockVersion);
            }
            long heapAddress = Utils.readBytesAsUnsignedLong(bb, FractalHeap.this.sb.getSizeOfOffsets());
            if (heapAddress != FractalHeap.this.address) {
                throw new HdfException("Indirect block read from invalid fractal heap");
            }
            this.blockOffset = Utils.readBytesAsUnsignedLong(bb, FractalHeap.this.bytesToStoreOffset);
            if (this.checksumPresent()) {
                bb.position(bb.position() + 4);
            }
            this.data = FractalHeap.this.hdfFc.map(address, FractalHeap.this.getSizeOfDirectBlock(FractalHeap.this.blockIndex));
        }

        private boolean checksumPresent() {
            return FractalHeap.this.flags.get(1);
        }

        public ByteBuffer getData() {
            return this.data.order(ByteOrder.LITTLE_ENDIAN);
        }

        public long getBlockOffset() {
            return this.blockOffset;
        }

        public String toString() {
            return "DirectBlock [address=" + this.address + ", blockOffset=" + this.blockOffset + ", data=" + this.data + "]";
        }
    }

    private class IndirectBlock {
        private final List<Long> childBlockAddresses;

        private IndirectBlock(long address) {
            long childAddress;
            int headerSize = 5 + FractalHeap.this.sb.getSizeOfOffsets() + FractalHeap.this.bytesToStoreOffset + FractalHeap.this.currentRowsInRootIndirectBlock * FractalHeap.this.tableWidth * this.getRowSize() + 4;
            ByteBuffer bb = FractalHeap.this.hdfFc.readBufferFromAddress(address, headerSize);
            byte[] formatSignatureBytes = new byte[4];
            bb.get(formatSignatureBytes, 0, formatSignatureBytes.length);
            if (!Arrays.equals(INDIRECT_BLOCK_SIGNATURE, formatSignatureBytes)) {
                throw new HdfException("Fractal heap indirect block signature 'FHIB' not matched, at address " + address);
            }
            byte indirectBlockVersion = bb.get();
            if (indirectBlockVersion != 0) {
                throw new HdfException("Unsupported indirect block version detected. Version: " + indirectBlockVersion);
            }
            long heapAddress = Utils.readBytesAsUnsignedLong(bb, FractalHeap.this.sb.getSizeOfOffsets());
            if (heapAddress != FractalHeap.this.address) {
                throw new HdfException("Indirect block read from invalid fractal heap");
            }
            long blockOffset = Utils.readBytesAsUnsignedLong(bb, FractalHeap.this.bytesToStoreOffset);
            this.childBlockAddresses = new ArrayList<Long>(FractalHeap.this.currentRowsInRootIndirectBlock * FractalHeap.this.tableWidth);
            for (int i = 0; i < FractalHeap.this.currentRowsInRootIndirectBlock * FractalHeap.this.tableWidth && (childAddress = Utils.readBytesAsUnsignedLong(bb, this.getRowSize())) != -1L; ++i) {
                this.childBlockAddresses.add(childAddress);
            }
        }

        private boolean isIoFilters() {
            return FractalHeap.this.ioFiltersLength > 0;
        }

        private int getRowSize() {
            int size = FractalHeap.this.sb.getSizeOfOffsets();
            if (this.isIoFilters()) {
                size += FractalHeap.this.sb.getSizeOfLengths();
                size += 4;
            }
            return size;
        }
    }
}

