/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.validate.interceptor;

import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import com.jfinal.kit.Ret;
import io.jboot.utils.RequestUtil;
import io.jboot.utils.StrUtil;

public class ValidateInterceptorUtil {
    private static ValidExceptionRetBuilder validExceptionRetBuilder = ValidExceptionRetBuilder.DEFAULT_BUILDER;

    public static ValidExceptionRetBuilder getValidExceptionRetBuilder() {
        return validExceptionRetBuilder;
    }

    public static void setValidExceptionRetBuilder(ValidExceptionRetBuilder validExceptionRetBuilder) {
        ValidateInterceptorUtil.validExceptionRetBuilder = validExceptionRetBuilder;
    }

    static String buildErrorMessage(Invocation inv, String annotation) {
        StringBuilder sb = new StringBuilder();
        sb.append("method \"").append(inv.getController().getClass().getName()).append(".").append(inv.getMethodName()).append("()\"").append(" has intercepted by annotation ").append(annotation);
        return sb.toString();
    }

    static void renderValidException(Controller controller, String renderType, String formName, String message, String redirectUrl, String htmlPath, int errorCode) {
        String reason = StrUtil.isNotBlank(message) ? formName + " validate failed: " + message : formName + " validate failed.";
        switch (renderType) {
            case "default": {
                if (RequestUtil.isAjaxRequest(controller.getRequest()) || RequestUtil.isJsonContentType(controller.getRequest())) {
                    Ret baseRet = Ret.fail((Object)"message", (Object)message).set((Object)"reason", (Object)reason).set((Object)"errorCode", (Object)errorCode).setIfNotNull((Object)"formName", (Object)formName);
                    Ret ret = validExceptionRetBuilder.build(baseRet);
                    controller.renderJson((Object)ret);
                    break;
                }
                controller.renderText(reason);
                break;
            }
            case "json": {
                Ret baseRet = Ret.fail((Object)"message", (Object)message).set((Object)"reason", (Object)reason).set((Object)"errorCode", (Object)errorCode).setIfNotNull((Object)"formName", (Object)formName);
                Ret ret = validExceptionRetBuilder.build(baseRet);
                controller.renderJson((Object)ret);
                break;
            }
            case "redirect": {
                controller.redirect(redirectUrl);
                break;
            }
            case "html": {
                controller.render(htmlPath);
                break;
            }
            case "text": {
                controller.renderText(message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can not process render : " + renderType);
            }
        }
    }

    public static interface ValidExceptionRetBuilder {
        public static final ValidExceptionRetBuilder DEFAULT_BUILDER = ret -> ret;

        public Ret build(Ret var1);
    }
}

