/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.validate.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.validate.RegexValidate;
import io.jboot.web.validate.interceptor.ValidateInterceptorUtil;

public class RegexValidateInterceptor
implements Interceptor {
    private static final Log LOG = Log.getLog((String)"Validate");

    public void intercept(Invocation inv) {
        RegexValidate regexValidate = inv.getMethod().getAnnotation(RegexValidate.class);
        if (regexValidate != null && !this.validateRegex(inv, regexValidate)) {
            if (Jboot.isDevMode()) {
                LOG.error(ValidateInterceptorUtil.buildErrorMessage(inv, "@RegexValidate"));
            }
            return;
        }
        inv.invoke();
    }

    private boolean validateRegex(Invocation inv, RegexValidate regexValidate) {
        Object[] forms = regexValidate.value();
        if (ArrayUtil.isNullOrEmpty(forms)) {
            return true;
        }
        for (Object form : forms) {
            String formName = AnnotationUtil.get(form.name());
            String formType = AnnotationUtil.get(form.type());
            if (StrUtil.isBlank((String)formName)) {
                throw new IllegalArgumentException("@RegexForm.value must not be empty in " + inv.getController().getClass().getName() + "." + inv.getMethodName());
            }
            String value = null;
            if ("form".equalsIgnoreCase(formType)) {
                value = inv.getController().getPara(formName);
            } else if ("raw".equalsIgnoreCase(formType)) {
                try {
                    Object tmp;
                    JSONObject json = JSON.parseObject((String)inv.getController().getRawData());
                    if (json != null && (tmp = JSONPath.eval((Object)json, (String)("$." + formName))) != null) {
                        value = tmp.toString();
                    }
                }
                catch (Exception e) {
                    value = null;
                }
            } else {
                throw new IllegalArgumentException("@RegexValidate not support form type : " + formType + ", see : io.jboot.web.controller.validate.FormType");
            }
            if (value != null && value.trim().matches(form.regex())) continue;
            ValidateInterceptorUtil.renderValidException(inv.getController(), AnnotationUtil.get(regexValidate.renderType()), formName, AnnotationUtil.get(form.message()), AnnotationUtil.get(regexValidate.redirectUrl()), AnnotationUtil.get(regexValidate.htmlPath()), form.errorCode());
            return false;
        }
        return true;
    }
}

