/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.validate.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.validate.EmptyValidate;
import io.jboot.web.validate.interceptor.ValidateInterceptorUtil;

public class EmptyValidateInterceptor
implements Interceptor {
    private static final Log LOG = Log.getLog((String)"Validate");

    public void intercept(Invocation inv) {
        EmptyValidate emptyParaValidate = inv.getMethod().getAnnotation(EmptyValidate.class);
        if (emptyParaValidate != null && !this.validateEmpty(inv, emptyParaValidate)) {
            if (Jboot.isDevMode()) {
                LOG.error(ValidateInterceptorUtil.buildErrorMessage(inv, "@EmptyValidate"));
            }
            return;
        }
        inv.invoke();
    }

    private boolean validateEmpty(Invocation inv, EmptyValidate emptyParaValidate) {
        Object[] forms = emptyParaValidate.value();
        if (ArrayUtil.isNullOrEmpty(forms)) {
            return true;
        }
        for (Object formAnnotation : forms) {
            String formName = AnnotationUtil.get(formAnnotation.name());
            String formType = AnnotationUtil.get(formAnnotation.type());
            if (StrUtil.isBlank((String)formName)) {
                throw new IllegalArgumentException("@Form.value must not be empty in " + inv.getController().getClass().getName() + "." + inv.getMethodName());
            }
            String paraValue = null;
            if ("form".equalsIgnoreCase(formType)) {
                paraValue = inv.getController().getPara(formName);
            } else if ("raw".equalsIgnoreCase(formType)) {
                try {
                    Object tmp;
                    JSONObject json = JSON.parseObject((String)inv.getController().getRawData());
                    if (json != null && (tmp = JSONPath.eval((Object)json, (String)("$." + formName))) != null) {
                        paraValue = tmp.toString();
                    }
                }
                catch (Exception e) {
                    paraValue = null;
                }
            } else {
                throw new IllegalArgumentException("@EmptyValidate not support form type : " + formType + ", see : io.jboot.web.controller.validate.FormType");
            }
            if (paraValue != null && paraValue.trim().length() != 0) continue;
            ValidateInterceptorUtil.renderValidException(inv.getController(), AnnotationUtil.get(emptyParaValidate.renderType()), formName, AnnotationUtil.get(formAnnotation.message()), AnnotationUtil.get(emptyParaValidate.redirectUrl()), AnnotationUtil.get(emptyParaValidate.htmlPath()), formAnnotation.errorCode());
            return false;
        }
        return true;
    }
}

