/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.validate.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.validate.CaptchaValidate;
import io.jboot.web.validate.interceptor.ValidateInterceptorUtil;

public class CaptchaValidateInterceptor
implements Interceptor {
    private static final Log LOG = Log.getLog((String)"Validate");

    public void intercept(Invocation inv) {
        CaptchaValidate captchaValidate = inv.getMethod().getAnnotation(CaptchaValidate.class);
        if (captchaValidate != null && !this.validateCaptache(inv, captchaValidate)) {
            if (Jboot.isDevMode()) {
                LOG.error(ValidateInterceptorUtil.buildErrorMessage(inv, "@CaptchaValidate"));
            }
            return;
        }
        inv.invoke();
    }

    private boolean validateCaptache(Invocation inv, CaptchaValidate captchaValidate) {
        String formName = AnnotationUtil.get(captchaValidate.form());
        if (StrUtil.isBlank((String)formName)) {
            throw new IllegalArgumentException("@CaptchaValidate.form must not be empty in " + inv.getController().getClass().getName() + "." + inv.getMethodName());
        }
        Controller controller = inv.getController();
        if (controller.validateCaptcha(formName)) {
            return true;
        }
        ValidateInterceptorUtil.renderValidException(inv.getController(), AnnotationUtil.get(captchaValidate.renderType()), formName, AnnotationUtil.get(captchaValidate.message()), AnnotationUtil.get(captchaValidate.redirectUrl()), AnnotationUtil.get(captchaValidate.htmlPath()), captchaValidate.errorCode());
        return false;
    }
}

