/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.render;

import com.jfinal.core.Action;
import com.jfinal.kit.JsonKit;
import com.jfinal.render.IRenderFactory;
import com.jfinal.render.Render;
import com.jfinal.render.RenderManager;
import io.jboot.utils.DateUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.ResponseEntity;
import io.jboot.web.render.JbootResponseEntityRender;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JbootReturnValueRender
extends Render {
    protected IRenderFactory factory = RenderManager.me().getRenderFactory();
    protected Action action;
    protected Object value;
    protected Render render;
    protected String forwardTo;

    public JbootReturnValueRender(Action action, Object returnValue) {
        this.action = action;
        this.value = returnValue == null ? null : (this.isBaseType(returnValue) ? String.valueOf(returnValue) : returnValue);
        this.initRealRender();
    }

    protected void initRealRender() {
        if (this.value == null) {
            this.render = this.factory.getNullRender();
        } else if (this.value instanceof ResponseEntity) {
            this.render = new JbootResponseEntityRender((ResponseEntity)this.value);
        } else if (this.value instanceof String) {
            String newVal = ((String)this.value).toLowerCase();
            if (newVal.endsWith(".html") && !newVal.contains(":")) {
                this.render = this.factory.getTemplateRender((String)this.value);
            } else if (newVal.startsWith("error") && newVal.length() > 8) {
                String errorCodeStr;
                String trim = ((String)this.value).substring(5).trim();
                if (trim.startsWith(":") && StrUtil.isNumeric(errorCodeStr = trim.substring(1).trim())) {
                    this.render = this.factory.getErrorRender(Integer.parseInt(errorCodeStr));
                }
                if (this.render == null) {
                    this.render = this.factory.getTextRender((String)this.value);
                }
            } else if (newVal.startsWith("forward")) {
                String trim = ((String)this.value).substring(7).trim();
                if (trim.startsWith(":")) {
                    this.forwardTo = trim.substring(1).trim();
                } else {
                    this.render = this.factory.getTextRender((String)this.value);
                }
            } else if (newVal.startsWith("redirect")) {
                String redirectTo;
                String trim = ((String)this.value).substring(8).trim();
                if (trim.startsWith(":") && StrUtil.isNotBlank(redirectTo = trim.substring(1).trim())) {
                    this.render = this.factory.getRedirectRender(redirectTo);
                }
                if (this.render == null) {
                    this.render = this.factory.getTextRender((String)this.value);
                }
            } else {
                this.render = this.factory.getTextRender((String)this.value);
            }
        } else {
            this.render = this.value instanceof Date ? this.factory.getTextRender(DateUtil.toDateTimeString((Date)this.value)) : (this.value instanceof File ? this.factory.getFileRender((File)this.value) : (this.value instanceof Render ? (Render)this.value : this.factory.getJsonRender(JsonKit.toJson((Object)this.value))));
        }
    }

    public Render setContext(HttpServletRequest request, HttpServletResponse response) {
        this.render.setContext(request, response);
        return this;
    }

    public Render setContext(HttpServletRequest request, HttpServletResponse response, String viewPath) {
        this.render.setContext(request, response, viewPath);
        return this;
    }

    public void render() {
        this.render.render();
    }

    protected boolean isBaseType(Object value) {
        Class<?> c = value.getClass();
        return c == String.class || c == Character.TYPE || c == Integer.class || c == Integer.TYPE || c == Long.class || c == Long.TYPE || c == Double.class || c == Double.TYPE || c == Float.class || c == Float.TYPE || c == Boolean.class || c == Boolean.TYPE || c == Short.class || c == Short.TYPE || c == BigDecimal.class || c == BigInteger.class;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }
}

