/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.render;

import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderManager;
import com.jfinal.template.Engine;
import io.jboot.Jboot;
import io.jboot.ext.MixedByteArrayOutputStream;
import io.jboot.utils.StrUtil;
import io.jboot.web.render.cdn.CdnUtil;
import io.jboot.web.render.cdn.JbootWebCdnConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class JbootRender
extends Render {
    private static Engine engine;
    private static final String contentType;
    private static JbootWebCdnConfig cdnConfig;

    private Engine getEngine() {
        if (engine == null) {
            engine = RenderManager.me().getEngine();
        }
        return engine;
    }

    public JbootRender(String view) {
        if (StrUtil.isBlank((String)view)) {
            throw new IllegalArgumentException("view cannot be null or empty.");
        }
        this.view = view;
    }

    public String getContentType() {
        return contentType;
    }

    public void render() {
        this.response.setContentType(this.getContentType());
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            data.put(attrName, this.request.getAttribute(attrName));
        }
        try {
            if (cdnConfig.isEnable()) {
                this.renderWithCdn(data);
            } else {
                this.getEngine().getTemplate(this.view).render(data, (Writer)this.response.getWriter());
            }
        }
        catch (RuntimeException e) {
            String name;
            Throwable cause = e.getCause();
            if (cause instanceof IOException && ("ClientAbortException".equals(name = cause.getClass().getSimpleName()) || "EofException".equals(name))) {
                return;
            }
            throw e;
        }
        catch (IOException e) {
            throw new RenderException((Throwable)e);
        }
    }

    private void renderWithCdn(Map<Object, Object> data) throws IOException {
        MixedByteArrayOutputStream baos = new MixedByteArrayOutputStream();
        this.getEngine().getTemplate(this.view).render(data, (OutputStream)baos);
        PrintWriter responseWriter = this.response.getWriter();
        responseWriter.write(CdnUtil.toHtml(baos.getInputStream(), cdnConfig.getDomain()));
    }

    public String toString() {
        return this.view;
    }

    static {
        contentType = "text/html; charset=" + JbootRender.getEncoding();
        cdnConfig = Jboot.config(JbootWebCdnConfig.class);
    }
}

