/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.render;

import com.jfinal.kit.JsonKit;
import com.jfinal.kit.Ret;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderManager;
import io.jboot.components.valid.ValidException;
import io.jboot.exception.JbootExceptionHolder;
import io.jboot.utils.RequestUtil;
import io.jboot.utils.StrUtil;
import java.io.PrintWriter;
import java.util.List;

public class JbootErrorRender
extends Render {
    protected static final String htmlContentType = "text/html;charset=" + JbootErrorRender.getEncoding();
    protected static final String jsonContentType = "application/json;charset=" + JbootErrorRender.getEncoding();
    protected static final String poweredBy = "<center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center>";
    protected static final String html404 = "<html><head><title>404 Not Found</title></head><body bgcolor='white'><center><h1>404 Not Found</h1></center><hr><center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center></body></html>";
    protected static final String html401 = "<html><head><title>401 Unauthorized</title></head><body bgcolor='white'><center><h1>401 Unauthorized</h1></center><hr><center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center></body></html>";
    protected static final String html403 = "<html><head><title>403 Forbidden</title></head><body bgcolor='white'><center><h1>403 Forbidden</h1></center><hr><center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center></body></html>";
    protected static final String html500_header = "<html><head><title>500 Internal Server Error</title></head><body bgcolor='white'><center><h1>500 Internal Server Error</h1></center><hr>";
    protected static final String html400_header = "<html><head><title>400 Internal Server Error</title></head><body bgcolor='white'><center><h1>400 Internal Server Error</h1></center><hr>";
    protected static final String html500_footer = "<hr><center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center></body></html>";
    protected static final String json401 = JsonKit.toJson((Object)Ret.fail().set((Object)"errorCode", (Object)401).set((Object)"message", (Object)"401 Unauthorized"));
    protected static final String json403 = JsonKit.toJson((Object)Ret.fail().set((Object)"errorCode", (Object)403).set((Object)"message", (Object)"403 Forbidden"));
    protected static final String json404 = JsonKit.toJson((Object)Ret.fail().set((Object)"errorCode", (Object)404).set((Object)"message", (Object)"404 Not Found"));
    protected int errorCode;
    protected String message;
    protected Throwable throwable;

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public JbootErrorRender(int errorCode, String view) {
        this.errorCode = errorCode;
        this.view = view;
    }

    public void render() {
        this.response.setStatus(this.getErrorCode());
        String view = this.getView();
        if (view != null) {
            RenderManager.me().getRenderFactory().getRender(view).setContext(this.request, this.response).render();
            return;
        }
        try {
            boolean needRenderJson = RequestUtil.isJsonContentType(this.request) || RequestUtil.isAjaxRequest(this.request);
            this.response.setContentType(needRenderJson ? jsonContentType : htmlContentType);
            PrintWriter writer = this.response.getWriter();
            writer.write(needRenderJson ? this.getErrorJson() : this.getErrorHtml());
        }
        catch (Exception ex) {
            throw new RenderException((Throwable)ex);
        }
    }

    public String getErrorHtml() {
        int errorCode = this.getErrorCode();
        if (this.throwable instanceof ValidException) {
            return this.buildErrorInfo(html400_header);
        }
        if (errorCode == 404) {
            return html404;
        }
        if (errorCode == 401) {
            return html401;
        }
        if (errorCode == 403) {
            return html403;
        }
        if (errorCode == 400) {
            return this.buildErrorInfo(html400_header);
        }
        if (errorCode == 500) {
            return this.buildErrorInfo(html500_header);
        }
        return "<html><head><title>" + errorCode + " Error</title></head><body bgcolor='white'><center><h1>" + errorCode + " Error</h1></center><hr>" + poweredBy + "</body></html>";
    }

    public String buildErrorInfo(String headerHtml) {
        StringBuilder stringBuilder = new StringBuilder(headerHtml);
        List<String> messages = JbootExceptionHolder.getMessages();
        for (String message : messages) {
            stringBuilder.append(message).append("<br />");
        }
        List<Throwable> throwables = JbootExceptionHolder.getThrowables();
        for (Throwable throwable : throwables) {
            StackTraceElement[] elems;
            stringBuilder.append(throwable.getClass().getName() + " : " + throwable.getMessage()).append("<br />");
            for (StackTraceElement element : elems = throwable.getStackTrace()) {
                stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;at ").append(element).append("<br />");
            }
        }
        return stringBuilder.append(html500_footer).toString();
    }

    public String getErrorJson() {
        int errorCode = this.getErrorCode();
        if (this.throwable instanceof ValidException || errorCode == 500 || errorCode == 400) {
            return this.buildErrorJson();
        }
        if (errorCode == 404) {
            return json404;
        }
        if (errorCode == 401) {
            return json401;
        }
        if (errorCode == 403) {
            return json403;
        }
        return JsonKit.toJson((Object)Ret.fail().set((Object)"errorCode", (Object)errorCode).set((Object)"message", (Object)(errorCode + " Error")));
    }

    public String buildErrorJson() {
        Ret ret = Ret.fail().set((Object)"errorCode", (Object)this.getErrorCode()).set((Object)"message", (Object)(this.getErrorCode() + " Internal Server Error"));
        StringBuilder errorMsgBuilder = new StringBuilder();
        List<String> messages = JbootExceptionHolder.getMessages();
        for (String message : messages) {
            errorMsgBuilder.append(message);
        }
        ret.set((Object)"errorMessage", (Object)errorMsgBuilder.toString());
        List<Throwable> throwables = JbootExceptionHolder.getThrowables();
        if (throwables.size() > 0) {
            Throwable throwable = throwables.get(0);
            ret.set((Object)"throwable", (Object)(throwable.getClass().getName() + ": " + throwable.getMessage()));
            ret.set((Object)"message", (Object)throwable.getMessage());
        }
        if (this.throwable != null) {
            ret.set((Object)"throwable", (Object)(this.throwable.getClass().getName() + ": " + this.throwable.getMessage()));
            ret.set((Object)"message", (Object)this.throwable.getMessage());
            if (this.throwable instanceof ValidException) {
                ret.set((Object)"errorMessage", (Object)((ValidException)this.throwable).getReason());
            }
        }
        if (StrUtil.isNotBlank(this.message)) {
            ret.set((Object)"message", (Object)this.message);
        }
        return JsonKit.toJson((Object)ret);
    }
}

