/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.render;

import com.jfinal.captcha.CaptchaRender;
import com.jfinal.kit.StrKit;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.QuadCurve2D;
import java.awt.image.BufferedImage;

public class JbootCaptchaRender
extends CaptchaRender {
    protected static char[] charArray = "1234567890ABCDEFGHJKMNPQRSTUVWXY".toCharArray();

    public static void setRandomArrayString(String randomArrayString) {
        if (StrKit.isBlank((String)randomArrayString)) {
            throw new IllegalArgumentException("randomArrayString can not be blank.");
        }
        charArray = randomArrayString.toCharArray();
    }

    protected String getRandomString() {
        char[] randomChars = new char[4];
        for (int i = 0; i < randomChars.length; ++i) {
            randomChars[i] = charArray[random.nextInt(charArray.length)];
        }
        return String.valueOf(randomChars);
    }

    protected void drawGraphic(String randomString, BufferedImage image) {
        int i;
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(this.getRandColor(210, 250));
        g.fillRect(0, 0, 108, 40);
        Color color = null;
        for (i = 0; i < 20; ++i) {
            color = this.getRandColor(120, 200);
            g.setColor(color);
            String rand = String.valueOf(charArray[random.nextInt(charArray.length)]);
            g.drawString(rand, random.nextInt(108), random.nextInt(40));
            color = null;
        }
        g.setFont(RANDOM_FONT[random.nextInt(RANDOM_FONT.length)]);
        for (i = 0; i < randomString.length(); ++i) {
            int degree = random.nextInt(28);
            if (i % 2 == 0) {
                degree *= -1;
            }
            int x = 22 * i;
            int y = 21;
            g.rotate(Math.toRadians(degree), x, y);
            color = this.getRandColor(20, 130);
            g.setColor(color);
            g.drawString(String.valueOf(randomString.charAt(i)), x + 8, y + 10);
            g.rotate(-Math.toRadians(degree), x, y);
        }
        g.setColor(color);
        BasicStroke bs = new BasicStroke(3.0f);
        g.setStroke(bs);
        QuadCurve2D.Double curve = new QuadCurve2D.Double(0.0, random.nextInt(32) + 4, 54.0, 20.0, 108.0, random.nextInt(32) + 4);
        g.draw(curve);
        g.dispose();
    }
}

