/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.ActionException;
import com.jfinal.core.Controller;
import com.jfinal.kit.LogKit;
import com.jfinal.render.RenderManager;
import io.jboot.aop.InterceptorBuilder;
import io.jboot.aop.Interceptors;
import io.jboot.aop.annotation.AutoLoad;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.ObjectUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.controller.JbootController;
import io.jboot.web.json.JsonBody;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@AutoLoad
public class JsonBodyParseInterceptor
implements Interceptor,
InterceptorBuilder {
    private static final String startOfArray = "[";
    private static final String endOfArray = "]";

    public void intercept(Invocation inv) {
        Controller controller = inv.getController();
        Method method = inv.getMethod();
        Parameter[] parameters = method.getParameters();
        Type[] paraTypes = method.getGenericParameterTypes();
        Object jsonObjectOrArray = StrUtil.isBlank((String)controller.getRawData()) ? null : JSON.parse((String)controller.getRawData());
        for (int index = 0; index < parameters.length; ++index) {
            JsonBody jsonBody = parameters[index].getAnnotation(JsonBody.class);
            if (jsonBody == null) continue;
            Class paraClass = parameters[index].getType();
            Object result = null;
            try {
                Type variableRawType;
                Type paraType = paraTypes[index];
                if (paraType instanceof TypeVariable && (variableRawType = JsonBodyParseInterceptor.getTypeVariableRawType(controller.getClass(), (TypeVariable)paraType)) != null) {
                    paraClass = (Class)variableRawType;
                    paraType = variableRawType;
                }
                result = JsonBodyParseInterceptor.parseJsonBody(jsonObjectOrArray, paraClass, paraType, jsonBody.value());
            }
            catch (Exception e) {
                String message = "Can not parse \"" + parameters[index].getType() + "\" in method " + ClassUtil.buildMethodString(method) + ", Cause: " + e.getMessage();
                if (jsonBody.skipConvertError()) {
                    LogKit.error((String)message);
                }
                throw new ActionException(400, RenderManager.me().getRenderFactory().getErrorRender(400), message);
            }
            inv.setArg(index, result);
        }
        inv.invoke();
    }

    private static Type getTypeVariableRawType(Class<?> defClass, TypeVariable<?> typeVariable) {
        Type type = defClass.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (typeArguments.length == 1) {
                return typeArguments[0];
            }
            if (typeArguments.length > 1) {
                TypeVariable<?>[] typeVariables = typeVariable.getGenericDeclaration().getTypeParameters();
                for (int i = 0; i < typeVariables.length; ++i) {
                    if (!typeVariable.getName().equals(typeVariables[i].getName())) continue;
                    return typeArguments[i];
                }
            }
        }
        return null;
    }

    public static Object parseJsonBody(Object jsonObjectOrArray, Class<?> paraClass, Type paraType, String jsonKey) throws InstantiationException, IllegalAccessException {
        if (jsonObjectOrArray == null) {
            return paraClass.isPrimitive() ? ObjectUtil.getPrimitiveDefaultValue(paraClass) : null;
        }
        if (Collection.class.isAssignableFrom(paraClass) || paraClass.isArray()) {
            return JsonBodyParseInterceptor.parseArray(jsonObjectOrArray, paraClass, paraType, jsonKey);
        }
        return JsonBodyParseInterceptor.parseObject((JSONObject)jsonObjectOrArray, paraClass, paraType, jsonKey);
    }

    private static Object parseObject(JSONObject rawObject, Class<?> paraClass, Type paraType, String jsonKey) throws IllegalAccessException, InstantiationException {
        if (StrUtil.isBlank((String)jsonKey)) {
            return JsonBodyParseInterceptor.toJavaObject(rawObject, paraClass, paraType);
        }
        Object result = null;
        String[] keys = jsonKey.split("\\.");
        for (int i = 0; i < keys.length; ++i) {
            String key;
            if (rawObject == null || rawObject.isEmpty() || !StrUtil.isNotBlank(key = keys[i].trim())) continue;
            if (i == keys.length - 1) {
                if (key.endsWith(endOfArray) && key.contains(startOfArray)) {
                    String realKey = key.substring(0, key.indexOf(startOfArray));
                    JSONArray jarray = rawObject.getJSONArray(realKey.trim());
                    if (jarray == null || jarray.size() <= 0) continue;
                    String arrayString = key.substring(key.indexOf(startOfArray) + 1, key.length() - 1);
                    int arrayIndex = StrUtil.isBlank((String)arrayString) ? 0 : Integer.parseInt(arrayString.trim());
                    result = arrayIndex >= jarray.size() ? null : jarray.get(arrayIndex);
                    continue;
                }
                result = rawObject.get((Object)key);
                continue;
            }
            rawObject = JsonBodyParseInterceptor.getJSONObjectByKey(rawObject, key);
        }
        if (result == null || "".equals(result)) {
            return paraClass.isPrimitive() ? ObjectUtil.getPrimitiveDefaultValue(paraClass) : null;
        }
        if (paraClass == String.class && paraClass == paraType) {
            return result.toString();
        }
        if (result instanceof JSONObject) {
            return JsonBodyParseInterceptor.toJavaObject((JSONObject)result, paraClass, paraType);
        }
        return ObjectUtil.convert(result, paraClass);
    }

    private static Object parseArray(Object rawJsonObjectOrArray, Class<?> typeClass, Type type, String jsonKey) {
        JSONArray jsonArray = null;
        if (StrUtil.isBlank((String)jsonKey)) {
            jsonArray = (JSONArray)rawJsonObjectOrArray;
        } else {
            JSONObject rawObject = (JSONObject)rawJsonObjectOrArray;
            String[] keys = jsonKey.split("\\.");
            for (int i = 0; i < keys.length && rawObject != null && !rawObject.isEmpty(); ++i) {
                String key = keys[i].trim();
                if (!StrUtil.isNotBlank(key)) continue;
                if (i == keys.length - 1) {
                    if (key.endsWith(endOfArray) && key.contains(startOfArray)) {
                        String realKey = key.substring(0, key.indexOf(startOfArray));
                        JSONArray jarray = rawObject.getJSONArray(realKey.trim());
                        if (jarray == null || jarray.isEmpty()) {
                            return null;
                        }
                        String subKey = key.substring(key.indexOf(startOfArray) + 1, key.length() - 1).trim();
                        if (StrUtil.isBlank((String)subKey)) {
                            throw new IllegalStateException("Sub key can not empty: " + jsonKey);
                        }
                        JSONArray newJsonArray = new JSONArray();
                        for (int j = 0; j < jarray.size(); ++j) {
                            Object value = jarray.getJSONObject(j).get((Object)subKey);
                            if (value == null) continue;
                            newJsonArray.add(value);
                        }
                        jsonArray = newJsonArray;
                        continue;
                    }
                    jsonArray = rawObject.getJSONArray(key);
                    continue;
                }
                rawObject = JsonBodyParseInterceptor.getJSONObjectByKey(rawObject, key);
            }
        }
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        if ((typeClass == Set.class || typeClass == HashSet.class) && typeClass == type) {
            return new HashSet(jsonArray);
        }
        if (typeClass == type && typeClass == JSONArray.class) {
            return jsonArray;
        }
        return jsonArray.toJavaObject(type);
    }

    private static JSONObject getJSONObjectByKey(JSONObject jsonObject, String key) {
        if (key.endsWith(endOfArray) && key.contains(startOfArray)) {
            String realKey = key.substring(0, key.indexOf(startOfArray));
            JSONArray jarray = jsonObject.getJSONArray(realKey.trim());
            if (jarray == null || jarray.isEmpty()) {
                return null;
            }
            String arrayString = key.substring(key.indexOf(startOfArray) + 1, key.length() - 1);
            int arrayIndex = StrUtil.isBlank((String)arrayString) ? 0 : Integer.parseInt(arrayString.trim());
            return arrayIndex >= jarray.size() ? null : jarray.getJSONObject(arrayIndex);
        }
        return jsonObject.getJSONObject(key);
    }

    private static Object toJavaObject(JSONObject rawObject, Class<?> paraClass, Type paraType) throws IllegalAccessException, InstantiationException {
        if (rawObject.isEmpty()) {
            return paraClass.isPrimitive() ? ObjectUtil.getPrimitiveDefaultValue(paraClass) : null;
        }
        if ((paraClass == Map.class || paraClass == JSONObject.class) && paraClass == paraType) {
            return rawObject;
        }
        if (Map.class.isAssignableFrom(paraClass) && paraClass == paraType && JsonBodyParseInterceptor.canNewInstance(paraClass)) {
            Map map = (Map)paraClass.newInstance();
            map.putAll(rawObject);
            return map;
        }
        return rawObject.toJavaObject(paraType);
    }

    private static boolean canNewInstance(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers);
    }

    @Override
    public void build(Class<?> targetClass, Method method, Interceptors interceptors) {
        Parameter[] parameters;
        if (InterceptorBuilder.Util.isController(targetClass) && (parameters = method.getParameters()) != null && parameters.length > 0) {
            for (Parameter p : parameters) {
                if (p.getAnnotation(JsonBody.class) == null) continue;
                Class<?> typeClass = p.getType();
                if ((Map.class.isAssignableFrom(typeClass) || Collection.class.isAssignableFrom(typeClass) || typeClass.isArray()) && !JbootController.class.isAssignableFrom(targetClass)) {
                    throw new IllegalArgumentException("Can not use @JsonBody for Map/List(Collection)/Array type if your controller not extends JbootController, method: " + ClassUtil.buildMethodString(method));
                }
                interceptors.addIfNotExist(this);
                return;
            }
        }
    }
}

