/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.jfinal.json.JFinalJson;
import com.jfinal.json.JFinalJsonKit;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.CPI;
import com.jfinal.plugin.activerecord.Model;
import io.jboot.Jboot;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.json.JbootJsonConfig;
import io.jboot.web.json.JsonIgnore;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JbootJson
extends JFinalJson {
    private JbootJsonConfig config = Jboot.config(JbootJsonConfig.class);
    protected static Map<Class<?>, MethodsAndFieldsWrapper> methodAndFieldsCache = new HashMap();
    protected JFinalJsonKit.ToJson<Model<?>> jbootModelToJson = (model, depth, ret) -> {
        if (JFinalJsonKit.checkDepth((int)depth--, (JFinalJsonKit.JsonResult)ret)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.config.isSkipModelAttrs()) {
            this.fillModelAttrsToMap(CPI.getAttrs((Model)model), map);
        }
        if (!this.config.isSkipBeanGetters()) {
            this.fillBeanToMap(model, map);
        }
        this.optimizeMapAttrs(map);
        JFinalJsonKit.mapToJson(map, (int)depth, (JFinalJsonKit.JsonResult)ret);
    };

    public JbootJson() {
        JbootJson.setSkipNullValueField((boolean)this.config.isSkipNullValueField());
        this.setConvertDepth(this.config.getDepth());
        if (this.config.isCamelCaseJsonStyleEnable()) {
            JbootJson.setModelAndRecordFieldNameConverter(fieldName -> StrKit.toCamelCase((String)fieldName, (boolean)this.config.isCamelCaseToLowerCaseAnyway()));
        }
        JbootJson.setToJsonFactory(o -> o instanceof Model ? this.jbootModelToJson : null);
        if (StrUtil.isNotBlank(this.config.getTimestampPattern())) {
            this.setTimestampPattern(this.config.getTimestampPattern());
        }
    }

    protected void fillModelAttrsToMap(Map<String, Object> attrs, Map<String, Object> toMap) {
        if (attrs != null && !attrs.isEmpty()) {
            for (Map.Entry<String, Object> entry : attrs.entrySet()) {
                String fieldName = entry.getKey();
                if (this.config.isCamelCaseJsonStyleEnable()) {
                    fieldName = StrKit.toCamelCase((String)fieldName, (boolean)this.config.isCamelCaseToLowerCaseAnyway());
                }
                toMap.put(fieldName, entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillBeanToMap(Object bean, Map<String, Object> toMap) {
        MethodsAndFieldsWrapper wrapper = methodAndFieldsCache.get(bean.getClass());
        if (wrapper == null) {
            JbootJson jbootJson = this;
            synchronized (jbootJson) {
                wrapper = wrapper == null ? new MethodsAndFieldsWrapper(bean.getClass()) : methodAndFieldsCache.get(bean.getClass());
            }
        }
        for (String ignoreField : wrapper.ignoreFields) {
            toMap.remove(ignoreField);
        }
        for (int i = 0; i < wrapper.fields.size(); ++i) {
            String originalField = (String)wrapper.originalFields.get(i);
            toMap.remove(originalField);
            Object value = this.invokeGetterMethod((Method)wrapper.getterMethods.get(i), bean);
            String field = (String)wrapper.fields.get(i);
            toMap.put(field, value);
        }
    }

    protected void optimizeMapAttrs(Map<String, Object> map) {
    }

    protected Object invokeGetterMethod(Method method, Object bean) {
        try {
            return method.invoke(bean, new Object[0]);
        }
        catch (Exception ex) {
            LogKit.error((String)("can not invoke method: " + ClassUtil.buildMethodString(method)), (Throwable)ex);
            return null;
        }
    }

    public <T> T parse(String jsonString, Class<T> type) {
        return (T)JSON.parseObject((String)jsonString, type);
    }

    public static class MethodsAndFieldsWrapper {
        private static boolean hasFastJson = ClassUtil.hasClass("com.alibaba.fastjson.JSON");
        private List<String> fields = new LinkedList<String>();
        private List<Method> getterMethods = new LinkedList<Method>();
        private List<String> originalFields = new LinkedList<String>();
        private List<String> ignoreFields = new ArrayList<String>();

        public MethodsAndFieldsWrapper(Class reflectiveClass) {
            Method[] methodArray;
            for (Method method : methodArray = reflectiveClass.getMethods()) {
                String fieldName;
                if (method.getParameterCount() != 0 || method.getReturnType() == Void.TYPE || !Modifier.isPublic(method.getModifiers()) || "getClass".equals(method.getName()) || (fieldName = this.getGetterMethodField(method.getName())) == null) continue;
                String attrName = StrKit.firstCharToLowerCase((String)fieldName);
                if (this.isIgnoreFiled(method)) {
                    this.ignoreFields.add(attrName);
                    continue;
                }
                this.originalFields.add(attrName);
                this.fields.add(this.getDefineName(method, attrName));
                this.getterMethods.add(method);
            }
        }

        private String getGetterMethodField(String methodName) {
            if (methodName.startsWith("get") && methodName.length() > 3) {
                return methodName.substring(3);
            }
            if (methodName.startsWith("is") && methodName.length() > 2) {
                return methodName.substring(2);
            }
            return null;
        }

        private String getDefineName(Method method, String orginalName) {
            JSONField jsonField;
            if (hasFastJson && (jsonField = method.getAnnotation(JSONField.class)) != null && StrUtil.isNotBlank(jsonField.name())) {
                return jsonField.name();
            }
            return orginalName;
        }

        private boolean isIgnoreFiled(Method method) {
            JSONField jsonField;
            if (hasFastJson && (jsonField = method.getAnnotation(JSONField.class)) != null && !jsonField.serialize()) {
                return true;
            }
            return method.getAnnotation(JsonIgnore.class) != null;
        }
    }
}

