/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.handler;

import com.google.common.base.Splitter;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Action;
import com.jfinal.core.ActionException;
import com.jfinal.core.CPI;
import com.jfinal.core.Controller;
import com.jfinal.log.Log;
import com.jfinal.render.RenderException;
import io.jboot.components.valid.ValidException;
import io.jboot.web.controller.JbootControllerContext;
import io.jboot.web.handler.JbootActionHandler;
import io.jboot.web.handler.JbootActionReporter;
import io.jboot.web.session.JbootServletRequestWrapper;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PathVariableActionHandler
extends JbootActionHandler {
    private static final Log LOG = Log.getLog(PathVariableActionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (target.lastIndexOf(46) != -1) {
            return;
        }
        isHandled[0] = true;
        String[] urlPara = new String[]{null, null};
        Action action = this.getAction(target, urlPara, request);
        if (action == null) {
            if (LOG.isWarnEnabled()) {
                String qs = request.getQueryString();
                LOG.warn("404 Action Not Found: " + (qs == null ? target : target + "?" + qs));
            }
            renderManager.getRenderFactory().getErrorRender(404).setContext(request, response).render();
            return;
        }
        Controller controller = null;
        try {
            controller = this.controllerFactory.getController(action.getControllerClass());
            if (urlPara[1] != null) {
                Map params = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)urlPara[1]);
                PathVariableWrappedRequest wrappedRequest = new PathVariableWrappedRequest(request, response, params);
                CPI._init_((Controller)controller, (Action)action, (HttpServletRequest)wrappedRequest, (HttpServletResponse)response, (String)urlPara[0]);
            } else {
                CPI._init_((Controller)controller, (Action)action, (HttpServletRequest)request, (HttpServletResponse)response, (String)urlPara[0]);
            }
            JbootControllerContext.hold(controller);
            Invocation invocation = this.getInvocation(action, controller);
            if (JbootActionReporter.isReportEnable()) {
                long time = System.currentTimeMillis();
                try {
                    this.doStartRender(target, action, controller, invocation, isHandled);
                }
                finally {
                    JbootActionReporter.report(target, controller, action, invocation, time);
                }
            } else {
                this.doStartRender(target, action, controller, invocation, isHandled);
            }
            this.doAfterRender(action, controller);
        }
        catch (RenderException e) {
            if (LOG.isErrorEnabled()) {
                String qs = request.getQueryString();
                LOG.error(qs == null ? target : target + "?" + qs, (Throwable)e);
            }
        }
        catch (ActionException e) {
            this.handleActionException(target, request, response, action, e);
        }
        catch (ValidException e) {
            this.handleValidException(target, request, response, action, e);
        }
        catch (Exception e) {
            this.handleException(target, request, response, action, e);
        }
        finally {
            JbootControllerContext.release();
            this.controllerFactory.recycle(controller);
        }
    }

    private class PathVariableWrappedRequest
    extends JbootServletRequestWrapper {
        private final Map<String, String[]> modifiableParameters;
        private Map<String, String[]> allParameters;

        public PathVariableWrappedRequest(HttpServletRequest request, HttpServletResponse response, Map<String, String> params) {
            super(request, response);
            this.allParameters = null;
            this.modifiableParameters = new TreeMap<String, String[]>();
            params.keySet().forEach(k -> this.modifiableParameters.put((String)k, new String[]{(String)params.get(k)}));
        }

        public Map<String, String[]> getParameterMap() {
            if (this.allParameters == null) {
                this.allParameters = new TreeMap<String, String[]>();
                this.allParameters.putAll(super.getParameterMap());
                this.allParameters.putAll(this.modifiableParameters);
            }
            return Collections.unmodifiableMap(this.allParameters);
        }

        public String getParameter(String name) {
            String[] strings = this.getParameterMap().get(name);
            if (strings != null) {
                return strings[0];
            }
            return super.getParameter(name);
        }
    }
}

