/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.handler;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public final class JbootActionReporterUtil {
    public static final char JVM_VOID = 'V';
    public static final char JVM_BOOLEAN = 'Z';
    public static final char JVM_BYTE = 'B';
    public static final char JVM_CHAR = 'C';
    public static final char JVM_DOUBLE = 'D';
    public static final char JVM_FLOAT = 'F';
    public static final char JVM_INT = 'I';
    public static final char JVM_LONG = 'J';
    public static final char JVM_SHORT = 'S';

    public static String getDesc(Class<?> c) {
        StringBuilder ret = new StringBuilder();
        while (c.isArray()) {
            ret.append('[');
            c = c.getComponentType();
        }
        if (c.isPrimitive()) {
            String t = c.getName();
            if ("void".equals(t)) {
                ret.append('V');
            } else if ("boolean".equals(t)) {
                ret.append('Z');
            } else if ("byte".equals(t)) {
                ret.append('B');
            } else if ("char".equals(t)) {
                ret.append('C');
            } else if ("double".equals(t)) {
                ret.append('D');
            } else if ("float".equals(t)) {
                ret.append('F');
            } else if ("int".equals(t)) {
                ret.append('I');
            } else if ("long".equals(t)) {
                ret.append('J');
            } else if ("short".equals(t)) {
                ret.append('S');
            }
        } else {
            ret.append('L');
            ret.append(c.getName().replace('.', '/'));
            ret.append(';');
        }
        return ret.toString();
    }

    public static String getMethodDescWithoutName(Method m) {
        StringBuilder ret = new StringBuilder();
        ret.append('(');
        Class<?>[] parameterTypes = m.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ret.append(JbootActionReporterUtil.getDesc(parameterTypes[i]));
        }
        ret.append(')').append(JbootActionReporterUtil.getDesc(m.getReturnType()));
        return ret.toString();
    }

    public static String getMethodString(Method m) {
        StringBuilder ret = new StringBuilder(m.getName());
        ret.append('(');
        Parameter[] parameters = m.getParameters();
        int index = 0;
        for (Parameter p : parameters) {
            if (!p.isNamePresent()) {
                throw new RuntimeException(" Maven or IDE config is error. see https://jfinal.com/doc/3-3 ");
            }
            ret.append(p.getType().getSimpleName());
            ret.append(" ").append(p.getName());
            if (index++ >= parameters.length - 1) continue;
            ret.append(", ");
        }
        ret.append(')');
        return ret.toString();
    }
}

