/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.handler;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Action;
import com.jfinal.core.ActionReporter;
import com.jfinal.core.Controller;
import com.jfinal.core.JFinal;
import com.jfinal.kit.JsonKit;
import com.jfinal.render.FileRender;
import com.jfinal.render.JsonRender;
import com.jfinal.render.NullRender;
import com.jfinal.render.RedirectRender;
import com.jfinal.render.Render;
import com.jfinal.render.TextRender;
import io.jboot.Jboot;
import io.jboot.JbootConsts;
import io.jboot.support.jwt.JwtInterceptor;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.ReflectUtil;
import io.jboot.utils.RequestUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.controller.JbootController;
import io.jboot.web.handler.ConsoleColor;
import io.jboot.web.handler.JbootActionReporterInvocation;
import io.jboot.web.handler.JbootActionReporterUtil;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletRequest;

public class JbootActionReporter {
    private static final String title = "\nJboot-" + JbootConsts.VERSION + " action report -------- ";
    private static final String interceptMethodDesc = "(Lcom/jfinal/aop/Invocation;)V";
    private static int maxOutputLengthOfParaValue = 512;
    private static Writer writer = new SystemOutWriter();
    private static ActionReporter actionReporter = JFinal.me().getConstants().getActionReporter();
    private static boolean reportEnable = Jboot.isDevMode();
    private static boolean colorRenderEnable = true;
    private static final ThreadLocal<SimpleDateFormat> sdf = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    public static void setMaxOutputLengthOfParaValue(int maxOutputLengthOfParaValue) {
        if (maxOutputLengthOfParaValue < 16) {
            throw new IllegalArgumentException("maxOutputLengthOfParaValue must more than 16");
        }
        JbootActionReporter.maxOutputLengthOfParaValue = maxOutputLengthOfParaValue;
    }

    public static void setWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer can not be null");
        }
        JbootActionReporter.writer = writer;
    }

    public static Writer getWriter() {
        return writer;
    }

    public static boolean isReportEnable() {
        return reportEnable;
    }

    public static void setReportEnable(boolean reportEnable) {
        JbootActionReporter.reportEnable = reportEnable;
    }

    public static boolean isColorRenderEnable() {
        return colorRenderEnable;
    }

    public static void setColorRenderEnable(boolean colorRenderEnable) {
        JbootActionReporter.colorRenderEnable = colorRenderEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(String target, Controller controller, Action action, Invocation invocation, long time) {
        try {
            JbootActionReporter.doReport(target, controller, action, invocation, time);
        }
        catch (NotFoundException e) {
            ClassPool.getDefault().insertClassPath((ClassPath)new ClassClassPath(controller.getClass()));
            try {
                JbootActionReporter.doReport(target, controller, action, invocation, time);
            }
            catch (Exception exception) {
                actionReporter.report(target, controller, action);
            }
        }
        catch (Exception ex) {
            actionReporter.report(target, controller, action);
        }
        finally {
            JbootActionReporterInvocation.clear();
        }
    }

    private static void doReport(String target, Controller controller, Action action, Invocation invocation, long time) throws Exception {
        String jwtString;
        HttpServletRequest request;
        Enumeration e;
        CtClass ctClass = ClassPool.getDefault().get(ClassUtil.getUsefulClass(action.getControllerClass()).getName());
        ClassPool.getDefault().get(ClassUtil.getUsefulClass(action.getControllerClass()).getName());
        String desc = JbootActionReporterUtil.getMethodDescWithoutName(action.getMethod());
        CtMethod ctMethod = ctClass.getMethod(action.getMethodName(), desc);
        int lineNumber = ctMethod.getMethodInfo().getLineNumber(0);
        StringBuilder sb = new StringBuilder(title).append(sdf.get().format(new Date(time))).append(" -------------------------\n");
        sb.append("Request     : ").append(controller.getRequest().getMethod()).append(" ").append(target).append("\n");
        Class<?> cc = action.getMethod().getDeclaringClass();
        sb.append("Controller  : ").append(cc.getName()).append(".(").append(JbootActionReporter.getClassFileName(cc)).append(".java:" + lineNumber + ")");
        if (JbootActionReporterInvocation.isControllerInvoked()) {
            sb.append((colorRenderEnable ? ConsoleColor.GREEN_BRIGHT : "") + " ---> invoked \u221a" + (colorRenderEnable ? ConsoleColor.RESET : ""));
        } else {
            sb.append((colorRenderEnable ? ConsoleColor.RED_BRIGHT : "") + " ---> skipped \u00d7" + (colorRenderEnable ? ConsoleColor.RESET : ""));
        }
        sb.append("\nMethod      : ").append(JbootActionReporterUtil.getMethodString(action.getMethod())).append("\n");
        String urlParas = controller.getPara();
        if (urlParas != null) {
            sb.append("UrlPara     : ").append(urlParas).append("\n");
        }
        Interceptor[] inters = invocation instanceof JbootActionReporterInvocation ? ((JbootActionReporterInvocation)invocation).getInters() : action.getInterceptors();
        List<Interceptor> invokedInterceptors = JbootActionReporterInvocation.getInvokedInterceptor();
        boolean printJwt = false;
        if (inters.length > 0) {
            sb.append("Interceptor : ");
            for (int i = 0; i < inters.length; ++i) {
                Interceptor inter;
                Class interClass;
                if (i > 0) {
                    sb.append("\n              ");
                }
                if ((interClass = ClassUtil.getUsefulClass((inter = inters[i]).getClass())) == JwtInterceptor.class) {
                    printJwt = true;
                }
                CtClass icClass = ClassPool.getDefault().get(interClass.getName());
                CtMethod icMethod = icClass.getMethod("intercept", interceptMethodDesc);
                int icLineNumber = icMethod.getMethodInfo().getLineNumber(0);
                sb.append(icMethod.getDeclaringClass().getName()).append(".(").append(JbootActionReporter.getClassFileName(interClass)).append(".java:" + icLineNumber + ")");
                if (invokedInterceptors.contains(inter)) {
                    sb.append((colorRenderEnable ? ConsoleColor.GREEN_BRIGHT : "") + " ---> invoked \u221a" + (colorRenderEnable ? ConsoleColor.RESET : ""));
                    continue;
                }
                sb.append((colorRenderEnable ? ConsoleColor.RED_BRIGHT : "") + " ---> skipped \u00d7" + (colorRenderEnable ? ConsoleColor.RESET : ""));
            }
            sb.append("\n");
        }
        if ((e = (request = controller.getRequest()).getParameterNames()).hasMoreElements()) {
            sb.append("Parameter   : ");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] values = request.getParameterValues(name);
                if (values.length == 1) {
                    sb.append(name).append("=");
                    if (values[0] != null && values[0].length() > maxOutputLengthOfParaValue) {
                        sb.append(values[0], 0, maxOutputLengthOfParaValue).append("...");
                    } else {
                        sb.append(values[0]);
                    }
                } else {
                    sb.append(name).append("[]={");
                    for (int i = 0; i < values.length; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(values[i]);
                    }
                    sb.append("}");
                }
                sb.append("  ");
            }
            sb.append("\n");
        }
        if (!"GET".equalsIgnoreCase(controller.getRequest().getMethod()) && !RequestUtil.isMultipartRequest(controller.getRequest()) && StrUtil.isNotBlank(controller.getRawData())) {
            sb.append("RawData     : ").append(controller.getRawData());
            sb.append("\n");
        }
        if (printJwt && controller instanceof JbootController && StrUtil.isNotBlank(jwtString = JsonKit.toJson((Object)((JbootController)controller).getJwtParas()))) {
            sb.append("Jwt         : ").append(jwtString.replace("\n", ""));
            sb.append("\n");
        }
        JbootActionReporter.appendRenderMessage(controller, sb);
        sb.append("----------------------------------- taked " + (System.currentTimeMillis() - time) + " ms --------------------------------\n\n\n");
        writer.write(sb.toString());
    }

    private static void appendRenderMessage(Controller controller, StringBuilder sb) {
        Render render = controller.getRender();
        if (render == null) {
            return;
        }
        String view = render.getView();
        if (StrUtil.isNotBlank(view)) {
            sb.append("Render      : ").append(view);
        } else if (render instanceof JsonRender) {
            String jsontext = ((JsonRender)render).getJsonText();
            if (jsontext == null) {
                jsontext = "";
            }
            if ((jsontext = jsontext.replace("\n", "")).length() > 100) {
                jsontext = jsontext.substring(0, 100) + "...";
            }
            sb.append("Render      : ").append(jsontext);
        } else if (render instanceof TextRender) {
            String text = ((TextRender)render).getText();
            if (text == null) {
                text = "";
            }
            if ((text = text.replace("\n", "")).length() > 100) {
                text = text.substring(0, 100) + "...";
            }
            sb.append("Render      : ").append(text);
        } else if (render instanceof FileRender) {
            File file = (File)ReflectUtil.getFieldValue(render, "file");
            sb.append("Render      : ").append(file);
        } else if (render instanceof RedirectRender) {
            String url = (String)ReflectUtil.getFieldValue(render, "url");
            sb.append("Redirect    : ").append(url);
        } else if (render instanceof NullRender) {
            sb.append("Render      :  null");
        } else {
            sb.append("Render      : ").append(ClassUtil.getUsefulClass(render.getClass()).getName());
        }
        sb.append("\n");
    }

    private static String getClassFileName(Class<?> clazz) {
        String classFileName = clazz.getName();
        if (classFileName.contains("$")) {
            int indexOf = classFileName.contains(".") ? classFileName.lastIndexOf(".") + 1 : 0;
            return classFileName.substring(indexOf, classFileName.indexOf("$"));
        }
        return clazz.getSimpleName();
    }

    private static class SystemOutWriter
    extends Writer {
        private SystemOutWriter() {
        }

        @Override
        public void write(String str) throws IOException {
            System.out.print(str);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

