/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.handler;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Action;
import com.jfinal.core.Controller;
import io.jboot.aop.InterceptorBuilderManager;
import io.jboot.aop.InterceptorCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JbootActionInvocation
extends Invocation {
    protected Action action;
    protected Object target;
    protected Object[] args;
    protected Interceptor[] inters;
    protected int index = 0;
    protected Object returnValue;
    protected static InterceptorBuilderManager builderManager = InterceptorBuilderManager.me();

    public JbootActionInvocation(Action action, Controller controller) {
        this.action = action;
        this.inters = this.buildInterceptors(action);
        this.target = controller;
        this.args = action.getParameterGetter().get(action, controller);
    }

    protected Interceptor[] buildInterceptors(Action action) {
        InterceptorCache.MethodKey key = InterceptorCache.getMethodKey(action.getControllerClass(), action.getMethod());
        Interceptor[] inters = InterceptorCache.get(key);
        if (inters == null) {
            inters = action.getInterceptors();
            inters = builderManager.build(action.getControllerClass(), action.getMethod(), inters);
            InterceptorCache.put(key, inters);
        }
        return inters;
    }

    public void invoke() {
        if (this.index < this.inters.length) {
            this.inters[this.index++].intercept((Invocation)this);
        } else if (this.index++ == this.inters.length) {
            try {
                this.returnValue = this.action.getMethod().invoke(this.target, this.args);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t == null) {
                    t = e;
                }
                throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public Object getArg(int index) {
        if (index >= this.args.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.args[index];
    }

    public void setArg(int index, Object value) {
        if (index >= this.args.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.args[index] = value;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public <T> T getTarget() {
        return (T)this.target;
    }

    public Method getMethod() {
        return this.action.getMethod();
    }

    public String getMethodName() {
        return this.action.getMethodName();
    }

    public <T> T getReturnValue() {
        return (T)this.returnValue;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    public Controller getController() {
        return (Controller)this.target;
    }

    public String getActionKey() {
        return this.action.getActionKey();
    }

    public String getControllerPath() {
        return this.action.getControllerPath();
    }

    @Deprecated
    public String getControllerKey() {
        return this.getControllerPath();
    }

    public String getViewPath() {
        return this.action.getViewPath();
    }

    public boolean isActionInvocation() {
        return this.action != null;
    }
}

