/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.handler;

import com.jfinal.aop.Invocation;
import com.jfinal.core.Action;
import com.jfinal.core.ActionException;
import com.jfinal.core.ActionHandler;
import com.jfinal.core.CPI;
import com.jfinal.core.Controller;
import com.jfinal.core.ForwardActionRender;
import com.jfinal.log.Log;
import com.jfinal.render.IRenderFactory;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.template.TemplateException;
import io.jboot.app.JbootApplicationConfig;
import io.jboot.components.cache.ActionCache;
import io.jboot.components.valid.ValidErrorRender;
import io.jboot.components.valid.ValidException;
import io.jboot.components.valid.ValidUtil;
import io.jboot.utils.ClassUtil;
import io.jboot.web.cached.CacheSupportResponseProxy;
import io.jboot.web.cached.CachedContent;
import io.jboot.web.controller.JbootControllerContext;
import io.jboot.web.handler.JbootActionInvocation;
import io.jboot.web.handler.JbootActionReporter;
import io.jboot.web.handler.JbootActionReporterInvocation;
import io.jboot.web.render.JbootErrorRender;
import io.jboot.web.render.JbootRenderFactory;
import io.jboot.web.render.JbootReturnValueRender;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JbootActionHandler
extends ActionHandler {
    private static final Log LOG = Log.getLog(JbootActionHandler.class);
    private static final JbootApplicationConfig appConfig = JbootApplicationConfig.get();

    public Action getAction(String target, String[] urlPara, HttpServletRequest request) {
        return this.getAction(target, urlPara);
    }

    protected Action getAction(String target, String[] urlPara) {
        return super.getAction(target, urlPara);
    }

    public Invocation getInvocation(Action action, Controller controller) {
        return JbootActionReporter.isReportEnable() ? new JbootActionReporterInvocation(action, controller) : new JbootActionInvocation(action, controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (target.lastIndexOf(46) != -1) {
            return;
        }
        isHandled[0] = true;
        String[] urlPara = new String[]{null};
        Action action = this.getAction(target, urlPara, request);
        if (action == null) {
            if (!appConfig.isHandle404()) {
                isHandled[0] = false;
                return;
            }
            if (LOG.isWarnEnabled()) {
                String qs = request.getQueryString();
                LOG.warn("404 Action Not Found: " + (qs == null ? target : target + "?" + qs));
            }
            renderManager.getRenderFactory().getErrorRender(404).setContext(request, response).render();
            return;
        }
        Controller controller = null;
        try {
            controller = this.controllerFactory.getController(action.getControllerClass());
            CPI._init_((Controller)controller, (Action)action, (HttpServletRequest)request, (HttpServletResponse)response, (String)urlPara[0]);
            JbootControllerContext.hold(controller);
            Invocation invocation = this.getInvocation(action, controller);
            if (JbootActionReporter.isReportEnable()) {
                long time = System.currentTimeMillis();
                try {
                    this.doStartRender(target, action, controller, invocation, isHandled);
                }
                finally {
                    JbootActionReporter.report(target, controller, action, invocation, time);
                }
            } else {
                this.doStartRender(target, action, controller, invocation, isHandled);
            }
            this.doAfterRender(action, controller);
        }
        catch (RenderException e) {
            if (LOG.isErrorEnabled()) {
                String qs = request.getQueryString();
                LOG.error(qs == null ? target : target + "?" + qs, (Throwable)e);
            }
        }
        catch (ActionException e) {
            if (e.getErrorCode() == 404 && !appConfig.isHandle404()) {
                isHandled[0] = false;
                return;
            }
            this.handleActionException(target, request, response, action, e);
        }
        catch (ValidException e) {
            this.handleValidException(target, request, response, action, e);
        }
        catch (TemplateException e) {
            this.handleTemplateException(target, request, response, action, e);
        }
        catch (Exception e) {
            this.handleException(target, request, response, action, e);
        }
        finally {
            JbootControllerContext.release();
            this.controllerFactory.recycle(controller);
        }
    }

    protected void doAfterRender(Action action, Controller controller) {
        if (controller.getResponse() instanceof CacheSupportResponseProxy) {
            CacheSupportResponseProxy responseProxy = (CacheSupportResponseProxy)controller.getResponse();
            CachedContent cachedContent = CachedContent.fromResponseProxy(responseProxy);
            ActionCache.putDataToCache(responseProxy.getCacheName(), responseProxy.getCacheKey(), cachedContent, responseProxy.getCacheLiveSeconds());
        }
    }

    protected void doStartRender(String target, Action action, Controller controller, Invocation invocation, boolean[] isHandled) {
        invocation.invoke();
        Render render = controller.getRender();
        if (render instanceof ForwardActionRender) {
            String actionUrl = ((ForwardActionRender)render).getActionUrl();
            if (target.equals(actionUrl)) {
                throw new RuntimeException("The forward action url is the same as before.");
            }
            this.handle(actionUrl, controller.getRequest(), controller.getResponse(), isHandled);
        } else {
            if (render == null && Void.TYPE != action.getMethod().getReturnType() && renderManager.getRenderFactory() instanceof JbootRenderFactory) {
                JbootRenderFactory factory = (JbootRenderFactory)renderManager.getRenderFactory();
                JbootReturnValueRender returnValueRender = factory.getReturnValueRender(action, invocation.getReturnValue());
                String forwardTo = returnValueRender.getForwardTo();
                if (forwardTo != null) {
                    this.handle(this.getRealForwrdTo(forwardTo, target, action), controller.getRequest(), controller.getResponse(), isHandled);
                    return;
                }
                render = returnValueRender;
            }
            if (render == null) {
                render = renderManager.getRenderFactory().getDefaultRender(action.getViewPath() + action.getMethodName());
            }
            render.setContext(controller.getRequest(), controller.getResponse(), action.getViewPath()).render();
        }
    }

    public String getRealForwrdTo(String forwardTo, String currentTarget, Action action) {
        if ("".equals(forwardTo)) {
            throw new IllegalArgumentException(ClassUtil.buildMethodString(action.getMethod()) + ": The forward key can not be blank.");
        }
        if (forwardTo.startsWith("/")) {
            return forwardTo;
        }
        if (forwardTo.startsWith("./")) {
            return currentTarget.substring(0, currentTarget.lastIndexOf("/")) + forwardTo.substring(1);
        }
        return "/" + forwardTo;
    }

    protected void handleActionException(String target, HttpServletRequest request, HttpServletResponse response, Action action, ActionException e) {
        int errorCode = e.getErrorCode();
        String msg = null;
        if (errorCode == 404) {
            msg = "404 Not Found: ";
        } else if (errorCode == 400) {
            msg = "400 Bad Request: ";
        } else if (errorCode == 401) {
            msg = "401 Unauthorized: ";
        } else if (errorCode == 403) {
            msg = "403 Forbidden: ";
        }
        if (msg != null) {
            if (errorCode == 404 || errorCode == 401 || errorCode == 403) {
                if (LOG.isWarnEnabled()) {
                    String qs = request.getQueryString();
                    msg = msg + (qs == null ? target : target + "?" + qs);
                    LOG.info(msg, (Throwable)e);
                }
            } else if (LOG.isErrorEnabled()) {
                String qs = request.getQueryString();
                msg = msg + (qs == null ? target : target + "?" + qs);
                LOG.error(msg, (Throwable)e);
            }
        } else if (LOG.isErrorEnabled()) {
            String qs = request.getQueryString();
            LOG.error(errorCode + " Error: " + (qs == null ? target : target + "?" + qs), (Throwable)e);
        }
        e.getErrorRender().setContext(request, response, action.getViewPath()).render();
    }

    protected void handleValidException(String target, HttpServletRequest request, HttpServletResponse response, Action action, ValidException e) {
        ValidErrorRender render;
        IRenderFactory factory;
        if (LOG.isErrorEnabled()) {
            String qs = request.getQueryString();
            String targetInfo = qs == null ? target : target + "?" + qs;
            LOG.error(e.getReason() + " : " + targetInfo, (Throwable)e);
        }
        if ((factory = renderManager.getRenderFactory()) instanceof JbootRenderFactory) {
            render = ((JbootRenderFactory)factory).getValidErrorRender(e);
            render.setContext(request, response, action.getViewPath()).render();
        } else {
            render = renderManager.getRenderFactory().getErrorRender(ValidUtil.getErrorCode());
            if (render instanceof JbootErrorRender) {
                ((JbootErrorRender)((Object)render)).setThrowable(e);
            }
            render.setContext(request, response, action.getViewPath()).render();
        }
    }

    protected void handleTemplateException(String target, HttpServletRequest request, HttpServletResponse response, Action action, TemplateException e) {
        String qs = request.getQueryString();
        String targetInfo = qs == null ? target : target + "?" + qs;
        String info = ClassUtil.buildMethodString(action.getMethod());
        LOG.error(info + " \nQuery: " + targetInfo + "\n", (Throwable)e);
        IRenderFactory factory = renderManager.getRenderFactory();
        if (factory instanceof JbootRenderFactory) {
            ((JbootRenderFactory)factory).getTemplateErrorRender(e).setContext(request, response, action.getViewPath()).render();
        }
    }

    protected void handleException(String target, HttpServletRequest request, HttpServletResponse response, Action action, Exception e) {
        String qs = request.getQueryString();
        String targetInfo = qs == null ? target : target + "?" + qs;
        String info = ClassUtil.buildMethodString(action.getMethod());
        LOG.error(info + " \nQuery: " + targetInfo + "\n", (Throwable)e);
        renderManager.getRenderFactory().getErrorRender(500).setContext(request, response, action.getViewPath()).render();
    }
}

