/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.directive.base;

import com.jfinal.plugin.activerecord.Page;
import com.jfinal.template.Env;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.Scope;
import io.jboot.web.directive.base.JbootDirectiveBase;
import java.util.ArrayList;

public abstract class PaginateDirectiveBase
extends JbootDirectiveBase {
    private static final String PREVIOUS_CLASS_KEY = "previousClass";
    private static final String NEXT_CLASS_KEY = "nextClass";
    private static final String ACTIVE_CLASS_KEY = "activeClass";
    private static final String DISABLED_CLASS_KEY = "disabledClass";
    private static final String ONLY_SHOW_PREVIOUS_AND_NEXT_KEY = "onlyShowPreviousAndNext";
    private static final String PREVIOUS_TEXT_KEY = "previousText";
    private static final String NEXT_TEXT_KEY = "nextText";
    private static final String PAGE_ITEMS_NAME_KEY = "pageItemsName";
    private static final String PAGE_DATA_KEY = "pageData";
    private static final String SIBLINGS_ITEM_COUNT_KEY = "siblingsItemCount";
    private static final String START_ITEM_COUNT_KEY = "startItemCount";
    private static final String END_ITEM_COUNT_KEY = "endItemCount";
    private static final String DEFAULT_PREVIOUS_CLASS = "previous";
    private static final String DEFAULT_NEXT_CLASS = "next";
    private static final String DEFAULT_ACTIVE_CLASS = "active";
    private static final String DEFAULT_DISABLED_CLASS = "disabled";
    private static final String DEFAULT_PREVIOUS_TEXT = "\u4e0a\u4e00\u9875";
    private static final String DEFAULT_NEXT_TEXT = "\u4e0b\u4e00\u9875";
    private static final String DEFAULT_PAGE_ITEMS_NAME = "pages";
    private static final String DEFAULT_PAGE_DATA_KEY = "pageData";
    private static final String JAVASCRIPT_TEXT = "javascript:;";
    private static final String ELLIPSIS_TEXT = "...";
    private static final int SIBLINGS_ITEM_COUNT = 2;
    private static final int START_ITEM_COUNT = 1;
    private static final int END_ITEM_COUNT = 1;

    @Override
    public void onRender(Env env, Scope scope, Writer writer) {
        int endPage;
        int startPage;
        int totalPage;
        Page<?> page;
        int endItemCount;
        int startItemCount;
        String previousClass = this.getPara(PREVIOUS_CLASS_KEY, scope, DEFAULT_PREVIOUS_CLASS);
        String nextClass = this.getPara(NEXT_CLASS_KEY, scope, DEFAULT_NEXT_CLASS);
        String activeClass = this.getPara(ACTIVE_CLASS_KEY, scope, DEFAULT_ACTIVE_CLASS);
        String disabledClass = this.getPara(DISABLED_CLASS_KEY, scope, DEFAULT_DISABLED_CLASS);
        boolean onlyShowPreviousAndNext = this.getParaToBool(ONLY_SHOW_PREVIOUS_AND_NEXT_KEY, scope, (Boolean)false);
        String previousText = this.getPara(PREVIOUS_TEXT_KEY, scope, DEFAULT_PREVIOUS_TEXT);
        String nextText = this.getPara(NEXT_TEXT_KEY, scope, DEFAULT_NEXT_TEXT);
        String pageItemsName = this.getPara(PAGE_ITEMS_NAME_KEY, scope, DEFAULT_PAGE_ITEMS_NAME);
        String pageDataKey = this.getPara("pageData", scope, "pageData");
        int siblingsItemCount = this.getParaToInt(SIBLINGS_ITEM_COUNT_KEY, scope, (Integer)2);
        if (siblingsItemCount < 1) {
            siblingsItemCount = 2;
        }
        if ((startItemCount = this.getParaToInt(START_ITEM_COUNT_KEY, scope, (Integer)1).intValue()) < 1) {
            startItemCount = 1;
        }
        if ((endItemCount = this.getParaToInt(END_ITEM_COUNT_KEY, scope, (Integer)1).intValue()) < 1) {
            endItemCount = 1;
        }
        int currentPageNumber = (page = this.getPage(env, scope, writer)) == null ? 1 : page.getPageNumber();
        int n = totalPage = page == null ? 0 : page.getTotalPage();
        if (totalPage == 0) {
            return;
        }
        if (currentPageNumber > totalPage) {
            currentPageNumber = totalPage;
        }
        if ((startPage = currentPageNumber - siblingsItemCount) < 1) {
            startPage = 1;
        }
        if ((endPage = currentPageNumber + siblingsItemCount) > totalPage) {
            endPage = totalPage;
        }
        ArrayList<PaginateItem> pages = new ArrayList<PaginateItem>();
        if (currentPageNumber == 1) {
            pages.add(new PaginateItem(previousClass + " " + disabledClass, JAVASCRIPT_TEXT, previousText));
        } else {
            pages.add(new PaginateItem(previousClass, this.getUrl(currentPageNumber - 1, env, scope, writer), previousText));
        }
        if (!onlyShowPreviousAndNext) {
            int i;
            for (i = 1; i <= startItemCount; ++i) {
                if (i >= currentPageNumber - siblingsItemCount) continue;
                pages.add(new PaginateItem("", this.getUrl(i, env, scope, writer), i));
            }
            if (currentPageNumber > startItemCount + siblingsItemCount + 1) {
                pages.add(new PaginateItem(disabledClass, JAVASCRIPT_TEXT, ELLIPSIS_TEXT));
            }
            for (i = startPage; i <= endPage; ++i) {
                if (currentPageNumber == i) {
                    pages.add(new PaginateItem(activeClass, JAVASCRIPT_TEXT, i));
                    continue;
                }
                pages.add(new PaginateItem("", this.getUrl(i, env, scope, writer), i));
            }
            if (currentPageNumber < totalPage - siblingsItemCount - endItemCount) {
                pages.add(new PaginateItem(disabledClass, JAVASCRIPT_TEXT, ELLIPSIS_TEXT));
            }
            for (i = endItemCount - 1; i >= 0; --i) {
                if (i >= totalPage - (currentPageNumber + siblingsItemCount)) continue;
                pages.add(new PaginateItem("", this.getUrl(totalPage - i, env, scope, writer), totalPage - i));
            }
        }
        if (currentPageNumber == totalPage) {
            pages.add(new PaginateItem(nextClass + " " + disabledClass, JAVASCRIPT_TEXT, nextText));
        } else {
            pages.add(new PaginateItem(nextClass, this.getUrl(currentPageNumber + 1, env, scope, writer), nextText));
        }
        scope.setLocal((Object)pageItemsName, pages);
        scope.setLocal((Object)pageDataKey, page);
        this.renderBody(env, scope, writer);
    }

    protected abstract String getUrl(int var1, Env var2, Scope var3, Writer var4);

    protected abstract Page<?> getPage(Env var1, Scope var2, Writer var3);

    public boolean hasEnd() {
        return true;
    }

    public static class PaginateItem {
        private String style;
        private String url;
        private String text;

        public PaginateItem(String style, String url, Object text) {
            this.style = style;
            this.url = url;
            this.text = String.valueOf(text);
        }

        public String getStyle() {
            return this.style;
        }

        public void setStyle(String style) {
            this.style = style;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

