/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.directive;

import com.jfinal.kit.LogKit;
import com.jfinal.template.expr.ast.MethodKeyBuilder;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

public class SharedEnumObject
extends LinkedHashMap<String, Object> {
    private Class<? extends Enum<?>> enumClass;
    private Map<Long, Method> staticMethods;

    void init(Class<? extends Enum<?>> enumClass, Map<Long, Method> staticMethods) {
        this.enumClass = enumClass;
        this.staticMethods = staticMethods;
        for (Enum<?> e : enumClass.getEnumConstants()) {
            this.put(e.name(), e);
        }
    }

    protected Object invokeEnumMethod(String methodName) {
        return this.doInvokeEnumMethod(methodName, new Object[0]);
    }

    protected Object invokeEnumMethod(String methodName, Object para1) {
        return this.doInvokeEnumMethod(methodName, para1);
    }

    protected Object invokeEnumMethod(String methodName, Object para1, Object para2) {
        return this.doInvokeEnumMethod(methodName, para1, para2);
    }

    protected Object invokeEnumMethod(String methodName, Object para1, Object para2, Object para3) {
        return this.doInvokeEnumMethod(methodName, para1, para2, para3);
    }

    protected Object invokeEnumMethod(String methodName, Object para1, Object para2, Object para3, Object para4) {
        return this.doInvokeEnumMethod(methodName, para1, para2, para3, para4);
    }

    protected Object invokeEnumMethod(String methodName, Object para1, Object para2, Object para3, Object para4, Object para5) {
        return this.doInvokeEnumMethod(methodName, para1, para2, para3, para4, para5);
    }

    private Object doInvokeEnumMethod(String methodName, Object ... paras) {
        Method method = this.findMethod(methodName, paras);
        if (method == null) {
            throw new RuntimeException("Can not find the method: " + methodName + " with paras: " + Arrays.toString(paras) + " in enum: " + this.enumClass);
        }
        try {
            return method.invoke(null, paras);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public Object invoke(String method, Object ... paras) {
        return this.doInvokeEnumMethod(method, paras);
    }

    public static SharedEnumObject create(Class<? extends Enum<?>> enumClass) {
        try {
            String javaVersion;
            ClassPool pool = ClassPool.getDefault();
            CtClass objectCtClass = pool.getCtClass(Object.class.getName());
            CtClass supperClass = pool.get(SharedEnumObject.class.getName());
            CtClass newClass = pool.makeClass(SharedEnumObject.class.getName() + "_$$_" + enumClass.getSimpleName());
            newClass.setSuperclass(supperClass);
            newClass.setModifiers(1);
            Map<Long, Method> enumStaticMethods = SharedEnumObject.findEnumStaticMethods(enumClass);
            if (enumStaticMethods != null) {
                for (Method originalMethod : enumStaticMethods.values()) {
                    boolean isReturnVoid = Void.TYPE == originalMethod.getReturnType();
                    CtClass returnClass = isReturnVoid ? CtClass.voidType : objectCtClass;
                    CtClass[] parameterClassArray = SharedEnumObject.createParameterClassArray(originalMethod, pool);
                    CtMethod ctMethod = new CtMethod(returnClass, originalMethod.getName(), parameterClassArray, newClass);
                    ctMethod.setModifiers(1);
                    if (isReturnVoid) {
                        ctMethod.setBody("{invokeEnumMethod(\"" + originalMethod.getName() + "\",$$);}");
                    } else {
                        ctMethod.setBody("{return invokeEnumMethod(\"" + originalMethod.getName() + "\",$$);}");
                    }
                    newClass.addMethod(ctMethod);
                }
            }
            SharedEnumObject ret = (javaVersion = System.getProperty("java.version")) != null && javaVersion.startsWith("1.") ? (SharedEnumObject)newClass.toClass().newInstance() : (SharedEnumObject)newClass.toClass(SharedEnumObject.class).newInstance();
            ret.init(enumClass, enumStaticMethods);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static CtClass[] createParameterClassArray(Method originalMethod, ClassPool pool) throws NotFoundException {
        if (originalMethod.getParameterCount() == 0) {
            return new CtClass[0];
        }
        CtClass[] ret = new CtClass[originalMethod.getParameterCount()];
        int index = 0;
        for (Class<?> clazz : originalMethod.getParameterTypes()) {
            ret[index++] = pool.getCtClass(clazz.getName());
        }
        return ret;
    }

    private static Map<Long, Method> findEnumStaticMethods(Class<? extends Enum<?>> enumClass) {
        HashMap<Long, Method> retMap = null;
        try {
            Method[] methods;
            for (Method method : methods = enumClass.getDeclaredMethods()) {
                int methodModifiers = method.getModifiers();
                if (!Modifier.isPublic(methodModifiers) || !Modifier.isStatic(methodModifiers)) continue;
                if (retMap == null) {
                    retMap = new HashMap<Long, Method>();
                }
                retMap.put(SharedEnumObject.getMethodKey(enumClass, method.getName(), method.getParameterTypes()), method);
            }
        }
        catch (Exception ex) {
            LogKit.logNothing((Throwable)ex);
        }
        return retMap;
    }

    private Method findMethod(String methodName, Object ... args) {
        long key;
        Method method;
        Class[] argTypes = null;
        if (args != null && args.length > 0) {
            argTypes = new Class[args.length];
            int index = 0;
            for (Object arg : args) {
                argTypes[index++] = arg != null ? arg.getClass() : null;
            }
        }
        if ((method = this.staticMethods.get(key = SharedEnumObject.getMethodKey(this.enumClass, methodName, argTypes).longValue())) != null) {
            return method;
        }
        for (Method m : this.staticMethods.values()) {
            if (!m.getName().equals(methodName) || !this.isMatchParas(m.getParameterTypes(), args)) continue;
            this.staticMethods.put(key, m);
            return m;
        }
        return null;
    }

    private boolean isMatchParas(Class<?>[] parameterTypes, Object[] args) {
        if (args == null || args.length == 0) {
            return parameterTypes.length == 0;
        }
        if (parameterTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (args[i] == null || parameterTypes[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private static Long getMethodKey(Class<?> targetClass, String methodName, Class<?>[] argTypes) {
        return MethodKeyBuilder.getInstance().getMethodKey(targetClass, methodName, (Class[])argTypes);
    }
}

