/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.directive;

import com.jfinal.core.Controller;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.template.Env;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.Scope;
import io.jboot.utils.StrUtil;
import io.jboot.web.controller.JbootControllerContext;
import io.jboot.web.directive.base.PaginateDirectiveBase;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class JbootPaginateDirective
extends PaginateDirectiveBase {
    private static final String URL_PAGE_INFO = "page=";
    private static final String URL_QMARK = "?";
    private static final String URL_AMARK = "&";
    private static final String KEY_ANCHOR = "anchor";
    private static final String KEY_PAGE_ATTR = "pageAttr";
    private static final String DEFAULT_PAGE_ATTR = "page";

    @Override
    protected String getUrl(int pageNumber, Env env, Scope scope, Writer writer) {
        HttpServletRequest request = JbootControllerContext.get().getRequest();
        String queryString = request.getQueryString();
        String url = request.getRequestURI();
        if (StrUtil.isNotBlank(queryString)) {
            url = url.concat(URL_QMARK).concat(queryString);
        }
        String anchor = this.getPara(KEY_ANCHOR, scope, "");
        int index = url.indexOf(URL_PAGE_INFO);
        if (index != -1) {
            StringBuilder sb = new StringBuilder();
            sb.append(url, 0, index).append(URL_PAGE_INFO).append(pageNumber);
            int idx = url.indexOf(URL_AMARK, index);
            if (idx != -1) {
                sb.append(url.substring(idx));
            }
            return sb.append(anchor).toString();
        }
        if (StrUtil.isNotBlank(queryString)) {
            StringBuilder sb = new StringBuilder(url);
            return sb.append(URL_AMARK).append(URL_PAGE_INFO).append(pageNumber).append(anchor).toString();
        }
        StringBuilder sb = new StringBuilder(url);
        return sb.append(URL_QMARK).append(URL_PAGE_INFO).append(pageNumber).append(anchor).toString();
    }

    @Override
    protected Page<?> getPage(Env env, Scope scope, Writer writer) {
        Controller controller = JbootControllerContext.get();
        if (controller == null) {
            return null;
        }
        String pageAttr = this.getPara(KEY_PAGE_ATTR, scope, DEFAULT_PAGE_ATTR);
        Object page = controller.getAttr(pageAttr);
        if (page instanceof Page) {
            return (Page)page;
        }
        Enumeration attrNames = controller.getAttrNames();
        if (attrNames != null) {
            while (attrNames.hasMoreElements()) {
                Object attrValue = controller.getAttr((String)attrNames.nextElement());
                if (!(attrValue instanceof Page)) continue;
                return (Page)attrValue;
            }
        }
        return null;
    }
}

