/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.controller;

import io.jboot.aop.InterceptorBuilder;
import io.jboot.aop.Interceptors;
import io.jboot.aop.annotation.AutoLoad;
import io.jboot.web.controller.RequestMethodLimitInterceptor;
import io.jboot.web.controller.annotation.DeleteRequest;
import io.jboot.web.controller.annotation.GetRequest;
import io.jboot.web.controller.annotation.PatchRequest;
import io.jboot.web.controller.annotation.PostRequest;
import io.jboot.web.controller.annotation.PutRequest;
import java.lang.reflect.Method;
import java.util.HashSet;

@AutoLoad
public class RequestMethodLimitInterceptorBuilder
implements InterceptorBuilder {
    @Override
    public void build(Class<?> targetClass, Method method, Interceptors interceptors) {
        if (InterceptorBuilder.Util.isController(targetClass)) {
            HashSet<String> supportMethods = new HashSet<String>();
            if (InterceptorBuilder.Util.hasAnnotation(method, GetRequest.class)) {
                supportMethods.add("GET");
            }
            if (InterceptorBuilder.Util.hasAnnotation(method, PostRequest.class)) {
                supportMethods.add("POST");
            }
            if (InterceptorBuilder.Util.hasAnnotation(method, PutRequest.class)) {
                supportMethods.add("PUT");
            }
            if (InterceptorBuilder.Util.hasAnnotation(method, DeleteRequest.class)) {
                supportMethods.add("DELETE");
            }
            if (InterceptorBuilder.Util.hasAnnotation(method, PatchRequest.class)) {
                supportMethods.add("PATCH");
            }
            if (!supportMethods.isEmpty()) {
                interceptors.add(new RequestMethodLimitInterceptor(supportMethods));
            }
        }
    }
}

