/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.controller;

import com.alibaba.fastjson.JSON;
import com.jfinal.core.ActionException;
import com.jfinal.core.Controller;
import com.jfinal.core.NotAction;
import com.jfinal.kit.StrKit;
import com.jfinal.render.RenderManager;
import io.jboot.support.jwt.JwtManager;
import io.jboot.utils.RequestUtil;
import io.jboot.utils.StrUtil;
import io.jboot.utils.TypeDef;
import io.jboot.web.json.JsonBodyParseInterceptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class JbootController
extends Controller {
    private Object rawObject;
    private Map jwtParas;
    private Map<String, Object> jwtAttrs;

    protected void _clear_() {
        super._clear_();
        this.rawObject = null;
        this.jwtParas = null;
        this.jwtAttrs = null;
    }

    @NotAction
    public boolean isMobileBrowser() {
        return RequestUtil.isMobileBrowser(this.getRequest());
    }

    @NotAction
    public boolean isWechatBrowser() {
        return RequestUtil.isWechatBrowser(this.getRequest());
    }

    @NotAction
    public boolean isIEBrowser() {
        return RequestUtil.isIEBrowser(this.getRequest());
    }

    @NotAction
    public boolean isAjaxRequest() {
        return RequestUtil.isAjaxRequest(this.getRequest());
    }

    @NotAction
    public boolean isMultipartRequest() {
        return RequestUtil.isMultipartRequest(this.getRequest());
    }

    @NotAction
    public String getIPAddress() {
        return RequestUtil.getIpAddress(this.getRequest());
    }

    @NotAction
    public String getReferer() {
        return RequestUtil.getReferer(this.getRequest());
    }

    @NotAction
    public String getUserAgent() {
        return RequestUtil.getUserAgent(this.getRequest());
    }

    @NotAction
    public Controller setJwtAttr(String name, Object value) {
        if (this.jwtAttrs == null) {
            this.jwtAttrs = new HashMap<String, Object>();
        }
        this.jwtAttrs.put(name, value);
        return this;
    }

    @NotAction
    public Controller setJwtMap(Map map) {
        if (map == null) {
            throw new NullPointerException("Jwt map is null");
        }
        if (this.jwtAttrs == null) {
            this.jwtAttrs = new HashMap<String, Object>();
        }
        this.jwtAttrs.putAll(map);
        return this;
    }

    @NotAction
    public Controller setJwtEmpty() {
        this.jwtAttrs = new HashMap<String, Object>();
        return this;
    }

    @NotAction
    public <T> T getJwtAttr(String name) {
        return (T)(this.jwtAttrs == null ? null : this.jwtAttrs.get(name));
    }

    @NotAction
    public Map<String, Object> getJwtAttrs() {
        return this.jwtAttrs;
    }

    @NotAction
    public <T> T getJwtPara(String name, Object defaultValue) {
        T ret = this.getJwtPara(name);
        return (T)(ret != null ? ret : defaultValue);
    }

    @NotAction
    public <T> T getJwtPara(String name) {
        return (T)this.getJwtParas().get(name);
    }

    @NotAction
    public Integer getJwtParaToInt(String name, Integer defaultValue) {
        Integer ret = this.getJwtParaToInt(name);
        return ret != null ? ret : defaultValue;
    }

    @NotAction
    public Integer getJwtParaToInt(String name) {
        Object ret = this.getJwtParas().get(name);
        if (ret instanceof Number) {
            return ((Number)ret).intValue();
        }
        return ret != null ? Integer.valueOf(ret.toString()) : null;
    }

    @NotAction
    public Long getJwtParaToLong(String name, Long defaultValue) {
        Long ret = this.getJwtParaToLong(name);
        return ret != null ? ret : defaultValue;
    }

    @NotAction
    public Long getJwtParaToLong(String name) {
        Object ret = this.getJwtParas().get(name);
        if (ret instanceof Number) {
            return ((Number)ret).longValue();
        }
        return ret != null ? Long.valueOf(ret.toString()) : null;
    }

    @NotAction
    public String getJwtParaToString(String name, String defaultValue) {
        String ret = this.getJwtParaToString(name);
        return StrUtil.isNotBlank(ret) ? ret : defaultValue;
    }

    @NotAction
    public String getJwtParaToString(String name) {
        Object ret = this.getJwtParas().get(name);
        return ret != null ? ret.toString() : null;
    }

    @NotAction
    public BigInteger getJwtParaToBigInteger(String name, BigInteger defaultValue) {
        BigInteger ret = this.getJwtParaToBigInteger(name);
        return ret != null ? ret : defaultValue;
    }

    @NotAction
    public BigInteger getJwtParaToBigInteger(String name) {
        Object ret = this.getJwtParas().get(name);
        if (ret instanceof BigInteger) {
            return (BigInteger)ret;
        }
        if (ret instanceof Number) {
            return BigInteger.valueOf(((Number)ret).longValue());
        }
        return ret != null ? this.toBigInteger(ret.toString(), null) : null;
    }

    @NotAction
    public Map getJwtParas() {
        if (this.jwtParas == null) {
            this.jwtParas = JwtManager.me().parseJwtToken(this);
        }
        return this.jwtParas;
    }

    @NotAction
    public String createJwtToken() {
        if (this.jwtAttrs == null) {
            this.jwtAttrs = new HashMap<String, Object>();
        }
        return JwtManager.me().createJwtToken(this.jwtAttrs);
    }

    @NotAction
    public String getBaseUrl() {
        return RequestUtil.getBaseUrl(this.getRequest());
    }

    @NotAction
    public String getCurrentUrl() {
        return RequestUtil.getCurrentUrl(this.getRequest());
    }

    @NotAction
    public <T> T getRawObject() {
        if (this.rawObject == null && StrUtil.isNotBlank(this.getRawData())) {
            this.rawObject = JSON.parse((String)this.getRawData());
        }
        return (T)this.rawObject;
    }

    @NotAction
    public <T> T getRawObject(Class<T> typeClass) {
        return this.getRawObject(typeClass, null);
    }

    @NotAction
    public <T> T getRawObject(Class<T> typeClass, String jsonKey) {
        try {
            return (T)JsonBodyParseInterceptor.parseJsonBody(this.getRawObject(), typeClass, typeClass, jsonKey);
        }
        catch (Exception ex) {
            throw new ActionException(400, RenderManager.me().getRenderFactory().getErrorRender(400), ex.getMessage());
        }
    }

    @NotAction
    public <T> T getRawObject(TypeDef<T> typeDef) {
        return this.getRawObject(typeDef, null);
    }

    @NotAction
    public <T> T getRawObject(TypeDef<T> typeDef, String jsonKey) {
        try {
            return (T)JsonBodyParseInterceptor.parseJsonBody(this.getRawObject(), typeDef.getDefClass(), typeDef.getType(), jsonKey);
        }
        catch (Exception ex) {
            throw new ActionException(400, RenderManager.me().getRenderFactory().getErrorRender(400), ex.getMessage());
        }
    }

    @NotAction
    public <T> T getJsonBody() {
        if (this.rawObject == null && StrUtil.isNotBlank(this.getRawData())) {
            this.rawObject = JSON.parse((String)this.getRawData());
        }
        return (T)this.rawObject;
    }

    @NotAction
    public <T> T getJsonBody(Class<T> typeClass) {
        return this.getJsonBody(typeClass, null);
    }

    @NotAction
    public <T> T getJsonBody(Class<T> typeClass, String jsonKey) {
        try {
            return (T)JsonBodyParseInterceptor.parseJsonBody(this.getJsonBody(), typeClass, typeClass, jsonKey);
        }
        catch (Exception ex) {
            throw new ActionException(400, RenderManager.me().getRenderFactory().getErrorRender(400), ex.getMessage());
        }
    }

    @NotAction
    public <T> T getJsonBody(TypeDef<T> typeDef) {
        return this.getJsonBody(typeDef, null);
    }

    @NotAction
    public <T> T getJsonBody(TypeDef<T> typeDef, String jsonKey) {
        try {
            return (T)JsonBodyParseInterceptor.parseJsonBody(this.getJsonBody(), typeDef.getDefClass(), typeDef.getType(), jsonKey);
        }
        catch (Exception ex) {
            throw new ActionException(400, RenderManager.me().getRenderFactory().getErrorRender(400), ex.getMessage());
        }
    }

    @NotAction
    public <T> T getBean(Class<T> beanClass, String beanName, boolean skipConvertError) {
        if (Collection.class.isAssignableFrom(beanClass) || Map.class.isAssignableFrom(beanClass) || beanClass.isArray()) {
            return null;
        }
        return (T)super.getBean(beanClass, beanName, skipConvertError);
    }

    @NotAction
    public Map<String, String> getParas() {
        HashMap<String, String> map = null;
        Enumeration names = this.getParaNames();
        if (names != null) {
            map = new HashMap<String, String>();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                map.put(name, this.getPara(name));
            }
        }
        return map;
    }

    @NotAction
    public String getTrimPara(String name) {
        String value = super.getPara(name);
        value = value == null ? null : value.trim();
        return "".equals(value) ? null : value;
    }

    @NotAction
    public String getTrimPara(int index) {
        String value = super.getPara(index);
        value = value == null ? null : value.trim();
        return "".equals(value) ? null : value;
    }

    @NotAction
    public String getEscapePara(String name) {
        String value = this.getTrimPara(name);
        if (value == null || value.length() == 0) {
            return null;
        }
        return StrUtil.escapeHtml(value);
    }

    @NotAction
    public String getEscapePara(String name, String defaultValue) {
        String value = this.getTrimPara(name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return StrUtil.escapeHtml(value);
    }

    @NotAction
    public String getUnescapePara(String name) {
        String value = this.getTrimPara(name);
        if (value == null || value.length() == 0) {
            return null;
        }
        return StrUtil.unEscapeHtml(value);
    }

    @NotAction
    public String getUnescapePara(String name, String defaultValue) {
        String value = this.getTrimPara(name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return StrUtil.unEscapeHtml(value);
    }

    @NotAction
    public String getOriginalPara(String name) {
        String value = this.getOrginalRequest().getParameter(name);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    @NotAction
    public HttpServletRequest getOrginalRequest() {
        HttpServletRequest req = this.getRequest();
        if (req instanceof HttpServletRequestWrapper) {
            req = this.getOrginalRequest((HttpServletRequestWrapper)req);
        }
        return req;
    }

    private HttpServletRequest getOrginalRequest(HttpServletRequestWrapper wrapper) {
        HttpServletRequest req = (HttpServletRequest)wrapper.getRequest();
        if (req instanceof HttpServletRequestWrapper) {
            return this.getOrginalRequest((HttpServletRequestWrapper)req);
        }
        return req;
    }

    @NotAction
    public String getOriginalPara(String name, String defaultValue) {
        String value = this.getOriginalPara(name);
        return value != null ? value : defaultValue;
    }

    private BigInteger toBigInteger(String value, BigInteger defaultValue) {
        try {
            if (StrKit.isBlank((String)value)) {
                return defaultValue;
            }
            if ((value = value.trim()).startsWith("N") || value.startsWith("n")) {
                return BigInteger.ZERO.subtract(new BigInteger(value.substring(1)));
            }
            return new BigInteger(value);
        }
        catch (Exception e) {
            throw new ActionException(400, RenderManager.me().getRenderFactory().getErrorRender(400), "Can not parse the parameter \"" + value + "\" to BigInteger value.");
        }
    }

    @NotAction
    public BigInteger getParaToBigInteger() {
        return this.toBigInteger(this.getPara(), null);
    }

    @NotAction
    public BigInteger getParaToBigInteger(String name) {
        return this.toBigInteger(this.getTrimPara(name), null);
    }

    @NotAction
    public BigInteger getParaToBigInteger(String name, BigInteger defaultValue) {
        return this.toBigInteger(this.getTrimPara(name), defaultValue);
    }

    @NotAction
    public BigInteger getBigInteger() {
        return this.toBigInteger(this.getPara(), null);
    }

    @NotAction
    public BigInteger getBigInteger(String name) {
        return this.toBigInteger(this.getTrimPara(name), null);
    }

    @NotAction
    public BigInteger getBigInteger(String name, BigInteger defaultValue) {
        return this.toBigInteger(this.getTrimPara(name), defaultValue);
    }

    private BigDecimal toBigDecimal(String value, BigDecimal defaultValue) {
        try {
            if (StrKit.isBlank((String)value)) {
                return defaultValue;
            }
            if ((value = value.trim()).startsWith("N") || value.startsWith("n")) {
                return BigDecimal.ZERO.subtract(new BigDecimal(value.substring(1)));
            }
            return new BigDecimal(value);
        }
        catch (Exception e) {
            throw new ActionException(400, RenderManager.me().getRenderFactory().getErrorRender(400), "Can not parse the parameter \"" + value + "\" to BigDecimal value.");
        }
    }

    @NotAction
    public BigDecimal getParaToBigDecimal() {
        return this.toBigDecimal(this.getPara(), null);
    }

    @NotAction
    public BigDecimal getParaToBigDecimal(String name) {
        return this.toBigDecimal(this.getTrimPara(name), null);
    }

    @NotAction
    public BigDecimal getParaToBigDecimal(String name, BigDecimal defaultValue) {
        return this.toBigDecimal(this.getTrimPara(name), defaultValue);
    }

    @NotAction
    public BigDecimal getBigDecimal() {
        return this.toBigDecimal(this.getPara(), null);
    }

    @NotAction
    public BigDecimal getBigDecimal(String name) {
        return this.toBigDecimal(this.getTrimPara(name), null);
    }

    @NotAction
    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        return this.toBigDecimal(this.getTrimPara(name), defaultValue);
    }
}

