/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.cached;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import java.util.Locale;

public class CacheSupportWriter
extends PrintWriter {
    final PrintWriter proxy;
    final StringWriter cached;
    private Formatter formatter;

    public CacheSupportWriter(PrintWriter proxy) {
        super(proxy);
        this.proxy = proxy;
        this.cached = new StringWriter();
    }

    @Override
    public void flush() {
        this.proxy.flush();
        this.cached.flush();
    }

    @Override
    public void close() {
        this.proxy.close();
        try {
            this.cached.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean checkError() {
        return this.proxy.checkError();
    }

    @Override
    public void write(int c) {
        this.proxy.write(c);
        this.cached.write(c);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.proxy.write(buf, off, len);
        this.cached.write(buf, off, len);
    }

    @Override
    public void write(char[] buf) {
        this.proxy.write(buf);
        try {
            this.cached.write(buf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(String s, int off, int len) {
        this.proxy.write(s, off, len);
        this.cached.write(s, off, len);
    }

    @Override
    public void write(String s) {
        this.proxy.write(s);
        this.cached.write(s);
    }

    @Override
    public void print(boolean b) {
        this.proxy.print(b);
        this.cached.write(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.proxy.print(c);
        this.cached.write(c);
    }

    @Override
    public void print(int i) {
        this.proxy.print(i);
        this.cached.write(i);
    }

    @Override
    public void print(long l) {
        this.proxy.print(l);
        this.cached.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.proxy.print(f);
        this.cached.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.proxy.print(d);
        this.cached.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.proxy.print(s);
        try {
            this.cached.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.proxy.print(s);
        this.cached.write(s);
    }

    @Override
    public void print(Object obj) {
        this.proxy.print(obj);
        this.cached.write(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.proxy.println();
        this.cached.write("\n");
    }

    @Override
    public void println(boolean x) {
        this.proxy.println(x);
        this.cached.write(x + "\n");
    }

    @Override
    public void println(char x) {
        this.proxy.println(x);
        this.cached.write(x + "\n");
    }

    @Override
    public void println(int x) {
        this.proxy.println(x);
        this.cached.write(x + "\n");
    }

    @Override
    public void println(long x) {
        this.proxy.println(x);
        this.cached.write(x + "\n");
    }

    @Override
    public void println(float x) {
        this.proxy.println(x);
        this.cached.write(x + "\n");
    }

    @Override
    public void println(double x) {
        this.proxy.println(x);
        this.cached.write(x + "\n");
    }

    @Override
    public void println(char[] x) {
        this.proxy.println(x);
        this.cached.write(x + "\n");
    }

    @Override
    public void println(String x) {
        this.proxy.println(x);
        this.cached.write(x + "\n");
    }

    @Override
    public void println(Object x) {
        this.proxy.println(x);
        this.cached.write(x + "\n");
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        this.format(format, args);
        return this;
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        this.format(l, format, args);
        return this;
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        this.proxy.format(format, args);
        if (this.formatter == null || this.formatter.locale() != Locale.getDefault()) {
            this.formatter = new Formatter(this.cached);
        }
        this.formatter.format(Locale.getDefault(), format, args);
        return this;
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        this.proxy.format(l, format, args);
        if (this.formatter == null || this.formatter.locale() != l) {
            this.formatter = new Formatter(this.cached, l);
        }
        this.formatter.format(l, format, args);
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        this.proxy.append(csq);
        this.cached.append(csq);
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        this.proxy.append(csq, start, end);
        this.cached.append(csq, start, end);
        return this;
    }

    @Override
    public PrintWriter append(char c) {
        this.proxy.append(c);
        this.cached.append(c);
        return this;
    }

    public String getWriterString() {
        return this.cached.toString();
    }
}

