/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.attachment;

import com.jfinal.ext.kit.DateKit;
import com.jfinal.kit.LogKit;
import io.jboot.utils.FileUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.attachment.AttachmentContainer;
import io.jboot.web.attachment.LocalAttachmentContainerConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class LocalAttachmentContainer
implements AttachmentContainer {
    private String rootPath;
    private String targetPrefix;

    public LocalAttachmentContainer() {
        LocalAttachmentContainerConfig config = LocalAttachmentContainerConfig.getInstance();
        this.rootPath = config.getRootPath();
        this.targetPrefix = config.getTargetPrefix();
    }

    public LocalAttachmentContainer(String rootPath, String targetPrefix) {
        this.rootPath = rootPath;
        this.targetPrefix = targetPrefix;
    }

    @Override
    public String saveFile(File file) {
        File newfile = this.creatNewFile(FileUtil.getSuffix(file.getName()));
        if (!newfile.getParentFile().exists()) {
            newfile.getParentFile().mkdirs();
        }
        try {
            FileUtils.moveFile((File)file, (File)newfile);
            newfile.setReadable(true, false);
        }
        catch (IOException e) {
            LogKit.error((String)e.toString(), (Throwable)e);
        }
        String attachmentRoot = this.getRootPath();
        return FileUtil.removePrefix(newfile.getAbsolutePath(), attachmentRoot);
    }

    @Override
    public String saveFile(File file, String toRelativePath) {
        File toFile = new File(this.getRootPath(), toRelativePath);
        try {
            if (toFile.equals(file)) {
                return toRelativePath;
            }
            if (!toFile.getParentFile().exists()) {
                toFile.getParentFile().mkdirs();
            }
            FileUtils.moveFile((File)file, (File)toFile);
            toFile.setReadable(true, false);
        }
        catch (IOException e) {
            LogKit.error((String)e.toString(), (Throwable)e);
        }
        return toRelativePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveFile(InputStream inputStream, String toRelativePath) {
        File toFile = new File(this.getRootPath(), toRelativePath);
        if (toFile.exists()) {
            toFile.delete();
        }
        if (!toFile.getParentFile().exists()) {
            toFile.getParentFile().mkdirs();
        }
        FileOutputStream fOutStream = null;
        try {
            int len;
            fOutStream = new FileOutputStream(toFile);
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                fOutStream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            try {
                LogKit.error((String)e.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtil.close(fOutStream, inputStream);
                throw throwable;
            }
            FileUtil.close(fOutStream, inputStream);
        }
        FileUtil.close(fOutStream, inputStream);
        return toRelativePath;
    }

    @Override
    public boolean deleteFile(String relativePath) {
        File file = this.getFile(relativePath);
        return file.exists() && file.delete();
    }

    public File creatNewFile(String suffix) {
        String rootPath = this.getRootPath();
        StringBuilder newFileName = new StringBuilder(rootPath).append(this.targetPrefix).append(File.separator).append(DateKit.toStr((Date)new Date(), (String)"yyyyMMdd")).append(File.separator).append(StrUtil.uuid()).append(suffix);
        return new File(newFileName.toString());
    }

    @Override
    public File getFile(String relativePath) {
        return new File(this.getRootPath(), relativePath);
    }

    @Override
    public String getRelativePath(File file) {
        String rootPath = this.getRootPath();
        String filePath = file.getAbsolutePath();
        return filePath.startsWith(rootPath) ? filePath.substring(rootPath.length()) : filePath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getTargetPrefix() {
        return this.targetPrefix;
    }

    public void setTargetPrefix(String targetPrefix) {
        this.targetPrefix = targetPrefix;
    }
}

