/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.attachment;

import com.jfinal.log.Log;
import com.jfinal.render.IRenderFactory;
import com.jfinal.render.Render;
import com.jfinal.render.RenderManager;
import io.jboot.utils.StrUtil;
import io.jboot.web.attachment.AttachmentContainer;
import io.jboot.web.attachment.LocalAttachmentContainer;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AttachmentManager {
    private static final Log LOG = Log.getLog(AttachmentManager.class);
    private static Map<String, AttachmentManager> managers = new HashMap<String, AttachmentManager>();
    private LocalAttachmentContainer defaultContainer = new LocalAttachmentContainer();
    private List<AttachmentContainer> containers = new CopyOnWriteArrayList<AttachmentContainer>();
    private IRenderFactory renderFactory = RenderManager.me().getRenderFactory();
    private final String name;

    public static AttachmentManager me() {
        return AttachmentManager.use("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AttachmentManager use(String name) {
        AttachmentManager manager = managers.get(name);
        if (manager != null) return manager;
        Class<AttachmentManager> clazz = AttachmentManager.class;
        synchronized (AttachmentManager.class) {
            manager = managers.get(name);
            if (manager != null) return manager;
            manager = new AttachmentManager(name);
            managers.put(name, manager);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return manager;
        }
    }

    private AttachmentManager(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public IRenderFactory getRenderFactory() {
        return this.renderFactory;
    }

    public void setRenderFactory(IRenderFactory renderFactory) {
        this.renderFactory = renderFactory;
    }

    public LocalAttachmentContainer getDefaultContainer() {
        return this.defaultContainer;
    }

    public void setDefaultContainer(LocalAttachmentContainer defaultContainer) {
        this.defaultContainer = defaultContainer;
    }

    public void addContainer(AttachmentContainer container) {
        this.containers.add(container);
    }

    public void setContainers(List<AttachmentContainer> containers) {
        this.containers = containers;
    }

    public List<AttachmentContainer> getContainers() {
        return this.containers;
    }

    public String saveFile(File file) {
        String relativePath = this.defaultContainer.saveFile(file);
        File defaultContainerFile = this.defaultContainer.getFile(relativePath);
        for (AttachmentContainer container : this.containers) {
            try {
                if (container == this.defaultContainer) continue;
                container.saveFile(defaultContainerFile);
            }
            catch (Exception ex) {
                LOG.error("Save file error in container :" + container, (Throwable)ex);
            }
        }
        return relativePath.replace("\\", "/");
    }

    public String saveFile(File file, String toRelativePath) {
        String relativePath = this.defaultContainer.saveFile(file, toRelativePath);
        File defaultContainerFile = this.defaultContainer.getFile(relativePath);
        for (AttachmentContainer container : this.containers) {
            try {
                if (container == this.defaultContainer) continue;
                container.saveFile(defaultContainerFile, toRelativePath);
            }
            catch (Exception ex) {
                LOG.error("Save file error in container :" + container, (Throwable)ex);
            }
        }
        return relativePath.replace("\\", "/");
    }

    public String saveFile(InputStream inputStream, String toRelativePath) {
        String relativePath = this.defaultContainer.saveFile(inputStream, toRelativePath);
        File defaultContainerFile = this.defaultContainer.getFile(relativePath);
        for (AttachmentContainer container : this.containers) {
            try {
                if (container == this.defaultContainer) continue;
                container.saveFile(defaultContainerFile, toRelativePath);
            }
            catch (Exception ex) {
                LOG.error("Save file error in container :" + container, (Throwable)ex);
            }
        }
        return relativePath.replace("\\", "/");
    }

    public boolean deleteFile(String relativePath) {
        for (AttachmentContainer container : this.containers) {
            try {
                container.deleteFile(relativePath);
            }
            catch (Exception ex) {
                LOG.error("Delete file error in container :" + container, (Throwable)ex);
            }
        }
        return this.defaultContainer.deleteFile(relativePath);
    }

    public File getFile(String relativePath) {
        return this.getFile(relativePath, true);
    }

    public File getFile(String relativePath, boolean localFirst) {
        File localFile;
        if (localFirst && (localFile = this.defaultContainer.getFile(relativePath)).exists()) {
            return localFile;
        }
        for (AttachmentContainer container : this.containers) {
            if (container == this.defaultContainer) continue;
            try {
                File file = container.getFile(relativePath);
                if (file == null || !file.exists()) continue;
                return file;
            }
            catch (Exception ex) {
                LOG.error("Get file error in container: " + container, (Throwable)ex);
            }
        }
        return this.defaultContainer.getFile(relativePath);
    }

    public String getRelativePath(File file) {
        String relativePath = this.defaultContainer.getRelativePath(file);
        return relativePath != null ? relativePath.replace("\\", "/") : null;
    }

    public File createNewFile(String suffix) {
        return this.getDefaultContainer().creatNewFile(suffix);
    }

    public boolean renderFile(String target, HttpServletRequest request, HttpServletResponse response) {
        if (StrUtil.isNotBlank(this.defaultContainer.getTargetPrefix()) && target.startsWith(this.defaultContainer.getTargetPrefix()) && target.lastIndexOf(46) != -1) {
            Render render = this.getFileRender(this.getFile(target));
            render.setContext(request, response).render();
            return true;
        }
        return false;
    }

    private Render getFileRender(File file) {
        return file == null || !file.isFile() ? this.renderFactory.getErrorRender(404) : this.renderFactory.getFileRender(file);
    }
}

