/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web;

import io.jboot.web.HttpStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ResponseEntity {
    private Object body;
    private Map<String, String> headers;
    private HttpStatus httpStatus = HttpStatus.OK;

    public ResponseEntity() {
    }

    public ResponseEntity(Object body) {
        this.body = body;
    }

    public ResponseEntity(Map<String, String> headers, HttpStatus httpStatus) {
        this.headers = headers;
        this.httpStatus = httpStatus;
    }

    public ResponseEntity(Object body, Map<String, String> headers, HttpStatus httpStatus) {
        this.body = body;
        this.headers = headers;
        this.httpStatus = httpStatus;
    }

    public ResponseEntity body(Object body) {
        this.body = body;
        return this;
    }

    public ResponseEntity header(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public ResponseEntity status(int status) {
        for (HttpStatus httpStatus : HttpStatus.values()) {
            if (!Objects.equals(httpStatus.value(), status)) continue;
            this.httpStatus = httpStatus;
            break;
        }
        return this;
    }

    public ResponseEntity status(HttpStatus status) {
        this.httpStatus = status;
        return this;
    }

    public <T> T getBody() {
        return (T)this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public static ResponseEntity ok() {
        ResponseEntity responseEntity = new ResponseEntity();
        return responseEntity.status(HttpStatus.OK);
    }
}

