/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web;

import com.google.common.base.Joiner;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorManager;
import com.jfinal.config.Routes;
import com.jfinal.core.Action;
import com.jfinal.core.ActionKey;
import com.jfinal.core.Controller;
import com.jfinal.core.NotAction;
import io.jboot.utils.AntPathMatcher;
import io.jboot.utils.ArrayUtil;
import io.jboot.web.JbootActionMapping;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PathVariableActionMapping
extends JbootActionMapping {
    private static final String PATH_VARIABLE_URL_PATTERN = ".*\\{[a-zA-Z0-9]+\\}.*";
    protected Map<String, Action> pathVariableUrlMapping = new ConcurrentHashMap<String, Action>();
    private static final AntPathMatcher antPathMatcher = new AntPathMatcher();

    public PathVariableActionMapping(Routes routes) {
        super(routes);
    }

    @Override
    protected void buildActionMapping() {
        this.mapping.clear();
        InterceptorManager interMan = InterceptorManager.me();
        for (Routes routes : this.getRoutesList()) {
            for (Routes.Route route : routes.getRouteItemList()) {
                Method[] methods;
                Class controllerClass = route.getControllerClass();
                Interceptor[] controllerInters = interMan.createControllerInterceptor(controllerClass);
                boolean declaredMethods = !routes.getMappingSuperClass() || controllerClass.getSuperclass() == Controller.class;
                block2: for (Method method : methods = declaredMethods ? controllerClass.getDeclaredMethods() : controllerClass.getMethods()) {
                    String actionKey;
                    Class<?> dc;
                    if (!declaredMethods ? (dc = method.getDeclaringClass()) == Controller.class || dc == Object.class : !Modifier.isPublic(method.getModifiers())) continue;
                    if (method.getAnnotation(NotAction.class) != null) continue;
                    Interceptor[] actionInters = interMan.buildControllerActionInterceptor(routes.getInterceptors(), controllerInters, controllerClass, method);
                    String controllerPath = route.getControllerPath();
                    String methodName = method.getName();
                    ActionKey ak = method.getAnnotation(ActionKey.class);
                    if (ak != null) {
                        actionKey = ak.value().trim();
                        if ("".equals(actionKey)) {
                            throw new IllegalArgumentException(controllerClass.getName() + "." + methodName + "(): The argument of ActionKey can not be blank.");
                        }
                        if (actionKey.matches(PATH_VARIABLE_URL_PATTERN)) {
                            Action pathVariableAction = new Action(controllerPath, actionKey, controllerClass, method, methodName, actionInters, route.getFinalViewPath(routes.getBaseViewPath()));
                            this.pathVariableUrlMapping.put(actionKey, pathVariableAction);
                        }
                        if (!actionKey.startsWith("/")) {
                            actionKey = actionKey.startsWith("./") ? controllerPath + actionKey.substring(1) : "/" + actionKey;
                        }
                    } else {
                        actionKey = methodName.equals("index") ? controllerPath : (controllerPath.equals("/") ? "/" + methodName : controllerPath + "/" + methodName);
                    }
                    Action newAction = new Action(controllerPath, actionKey, controllerClass, method, methodName, actionInters, route.getFinalViewPath(routes.getBaseViewPath()));
                    Action existAction = (Action)this.mapping.get(actionKey);
                    if (existAction == null) {
                        this.mapping.put(actionKey, newAction);
                        continue;
                    }
                    Type controllerType = controllerClass.getGenericSuperclass();
                    Method existActionMethod = existAction.getMethod();
                    if (!(controllerType instanceof ParameterizedType)) {
                        throw new RuntimeException(this.buildMsg(actionKey, method, existActionMethod));
                    }
                    if (method.getParameterCount() == 0 || method.getParameterCount() != existActionMethod.getParameterCount() || method.getDeclaringClass() != existActionMethod.getDeclaringClass()) {
                        throw new RuntimeException(this.buildMsg(actionKey, method, existActionMethod));
                    }
                    Type[] argumentTypes = ((ParameterizedType)controllerType).getActualTypeArguments();
                    Class<?>[] paraTypes = method.getParameterTypes();
                    Class<?>[] existParaTypes = existActionMethod.getParameterTypes();
                    for (int i = 0; i < paraTypes.length; ++i) {
                        Class<?> newType = paraTypes[i];
                        Class<?> existType = existParaTypes[i];
                        if (newType == existType) continue;
                        if (newType.isAssignableFrom(existType) && ArrayUtil.contains(argumentTypes, existType)) continue block2;
                        if (existType.isAssignableFrom(newType) && ArrayUtil.contains(argumentTypes, newType)) {
                            this.mapping.put(actionKey, newAction);
                            continue block2;
                        }
                        throw new RuntimeException(this.buildMsg(actionKey, method, existActionMethod));
                    }
                }
            }
        }
        this.routes.clear();
        Action action = (Action)this.mapping.get("/");
        if (action != null) {
            this.mapping.put("", action);
        }
    }

    public Action getAction(String url, String[] urlPara) {
        Action action = (Action)this.mapping.get(url);
        if (action != null) {
            return action;
        }
        for (String pattern : this.pathVariableUrlMapping.keySet()) {
            if (!antPathMatcher.match(pattern, url)) continue;
            Action pathVariableUrlAction = this.pathVariableUrlMapping.get(pattern);
            Map<String, String> pathVariableValues = antPathMatcher.extractUriTemplateVariables(pattern, url);
            urlPara[0] = null;
            if (urlPara.length > 1) {
                urlPara[1] = Joiner.on((String)"&").withKeyValueSeparator("=").join(pathVariableValues);
            }
            return pathVariableUrlAction;
        }
        int i = url.lastIndexOf(47);
        if (i != -1 && (action = (Action)this.mapping.get(url.substring(0, i))) != null) {
            urlPara[0] = url.substring(i + 1);
        }
        return action;
    }
}

