/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.kit.LogKit;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

public class ReflectUtil {
    public static <T> T getStaticFieldValue(Class<?> dClass, String fieldName) {
        return ReflectUtil.getFieldValue(dClass, fieldName, null);
    }

    public static <T> T getFieldValue(Object getFrom, String fieldName) {
        return ReflectUtil.getFieldValue(getFrom.getClass(), fieldName, getFrom);
    }

    private static <T> T getFieldValue(Class<?> dClass, String fieldName, Object getFrom) {
        try {
            if (StrUtil.isBlank((String)fieldName)) {
                throw new IllegalArgumentException("fieldName must not be null or empty.");
            }
            Field field = ReflectUtil.searchField(dClass, f -> f.getName().equals(fieldName));
            if (field == null) {
                throw new NoSuchFieldException(fieldName);
            }
            return ReflectUtil.getFileValue(getFrom, field);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getFileValue(Object getFrom, Field field) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(getFrom);
            return (T)object;
        }
        catch (IllegalAccessException e) {
            LogKit.error((String)e.toString(), (Throwable)e);
        }
        finally {
            field.setAccessible(accessible);
        }
        return null;
    }

    public static void setStaticFieldValue(Class<?> dClass, String fieldName, Object value) {
        ReflectUtil.setFieldValue(dClass, null, fieldName, value);
    }

    public static void setFieldValue(Object setTo, String fieldName, Object value) {
        ReflectUtil.setFieldValue(setTo.getClass(), setTo, fieldName, value);
    }

    private static void setFieldValue(Class<?> dClass, Object setTo, String fieldName, Object value) {
        ReflectUtil.setFieldValue(dClass, setTo, (Field f) -> f.getName().equals(fieldName), value);
    }

    private static void setFieldValue(Class<?> dClass, Object setTo, Predicate<Field> filter, Object value) {
        Field field = ReflectUtil.searchField(dClass, filter);
        if (field == null) {
            throw new IllegalArgumentException("No such field");
        }
        ReflectUtil.setFieldValue(setTo, value, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldValue(Object setTo, Object value, Field field) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(setTo, value);
        }
        catch (IllegalAccessException e) {
            LogKit.error((String)e.toString(), (Throwable)e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static Field searchField(Class<?> dClass, Predicate<Field> filter) {
        Field[] fields;
        if (dClass == null) {
            return null;
        }
        for (Field field : fields = dClass.getDeclaredFields()) {
            if (!filter.test(field)) continue;
            return field;
        }
        return ReflectUtil.searchField(dClass.getSuperclass(), filter);
    }

    public static List<Field> searchFieldList(Class<?> dClass, Predicate<Field> filter) {
        LinkedList<Field> fields = new LinkedList<Field>();
        ReflectUtil.doSearchFieldList(dClass, filter, fields);
        return fields;
    }

    private static void doSearchFieldList(Class<?> dClass, Predicate<Field> filter, List<Field> searchToList) {
        if (dClass == null || dClass == Object.class) {
            return;
        }
        Field[] fields = dClass.getDeclaredFields();
        if (fields.length > 0) {
            if (filter != null) {
                for (Field field : fields) {
                    if (!filter.test(field)) continue;
                    searchToList.add(field);
                }
            } else {
                searchToList.addAll(Arrays.asList(fields));
            }
        }
        ReflectUtil.doSearchFieldList(dClass.getSuperclass(), filter, searchToList);
    }

    public static Method searchMethod(Class<?> dClass, Predicate<Method> filter) {
        Method[] methods;
        if (dClass == null) {
            return null;
        }
        for (Method method : methods = dClass.getDeclaredMethods()) {
            if (!filter.test(method)) continue;
            return method;
        }
        return ReflectUtil.searchMethod(dClass.getSuperclass(), filter);
    }

    public static List<Method> searchMethodList(Class<?> dClass, Predicate<Method> filter) {
        LinkedList<Method> methods = new LinkedList<Method>();
        ReflectUtil.doSearchMethodList(dClass, filter, methods);
        return methods;
    }

    private static void doSearchMethodList(Class<?> dClass, Predicate<Method> filter, List<Method> searchToList) {
        if (dClass == null) {
            return;
        }
        Method[] methods = dClass.getDeclaredMethods();
        if (methods.length > 0) {
            if (filter != null) {
                for (Method method : methods) {
                    if (!filter.test(method)) continue;
                    searchToList.add(method);
                }
            } else {
                searchToList.addAll(Arrays.asList(methods));
            }
        }
        ReflectUtil.doSearchMethodList(dClass.getSuperclass(), filter, searchToList);
    }

    public static <T> T invokeStaticMethod(Class<?> dClass, String methodName, Object ... args) {
        return ReflectUtil.invokeStaticMethod(dClass, (Method m) -> m.getName().equals(methodName), args);
    }

    public static <T> T invokeStaticMethod(Class<?> dClass, Predicate<Method> filter, Object ... args) {
        Method method = ReflectUtil.searchMethod(dClass, filter);
        if (method == null) {
            throw new IllegalArgumentException("No such method.");
        }
        return ReflectUtil.invokeMethod(null, method, args);
    }

    public static <T> T invokeMethod(Object obj, String methodName, Object ... args) {
        return ReflectUtil.invokeMethod(obj, (Method m) -> m.getName().equals(methodName), args);
    }

    public static <T> T invokeMethod(Object obj, Predicate<Method> filter, Object ... args) {
        Method method = ReflectUtil.searchMethod(obj.getClass(), filter);
        if (method == null) {
            throw new IllegalArgumentException("No such method.");
        }
        return ReflectUtil.invokeMethod(obj, method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invokeMethod(Object obj, Method method, Object ... args) {
        boolean accessible = method.isAccessible();
        try {
            method.setAccessible(true);
            Object object = method.invoke(obj, args);
            return (T)object;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LogKit.error((String)e.toString(), (Throwable)e);
        }
        finally {
            method.setAccessible(accessible);
        }
        return null;
    }
}

