/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.kit.LogKit;
import java.io.Closeable;
import java.io.IOException;

public class QuietlyUtil {
    public static void closeQuietly(Closeable ... closeables) {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    LogKit.error((String)e.toString(), (Throwable)e);
                }
            }
        }
    }

    public static void sleepQuietly(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LogKit.error((String)e.toString(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

