/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import io.jboot.utils.DateUtil;
import io.jboot.utils.ObjectFunc;
import io.jboot.utils.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

public class ObjectUtil {
    public static <T> boolean isContainsObject(Collection<T> objects, T compareObject, ObjectFunc<T> ... compareAttrGetters) {
        if (objects == null || objects.isEmpty() || compareObject == null) {
            return false;
        }
        if (compareAttrGetters == null || compareAttrGetters.length == 0) {
            throw new IllegalArgumentException("compareAttrGetters must not be null");
        }
        for (T object : objects) {
            if (!ObjectUtil.isSameObject(object, compareObject, compareAttrGetters)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getContainsObject(Collection<T> objects, T compareObject, ObjectFunc<T> ... compareAttrGetters) {
        if (objects == null || objects.isEmpty() || compareObject == null) {
            return null;
        }
        if (compareAttrGetters == null || compareAttrGetters.length == 0) {
            throw new IllegalArgumentException("compareAttrGetters must not be null");
        }
        for (T object : objects) {
            if (!ObjectUtil.isSameObject(object, compareObject, compareAttrGetters)) continue;
            return object;
        }
        return null;
    }

    public static <T> boolean isSameObject(T object1, T object2, ObjectFunc<T> ... compareAttrGetters) {
        if (object1 == null || object2 == null) {
            return object1 == object2;
        }
        if (compareAttrGetters == null || compareAttrGetters.length == 0) {
            throw new IllegalArgumentException("compareAttrGetters must not be null");
        }
        for (ObjectFunc<T> getter : compareAttrGetters) {
            if (getter == null) {
                throw new IllegalArgumentException("compareAttrGetter must not be null");
            }
            if (Objects.equals(getter.get(object1), getter.get(object2))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean notSameObject(T object1, T object2, ObjectFunc<T> ... compareAttrGetters) {
        return !ObjectUtil.isSameObject(object1, object2, compareAttrGetters);
    }

    public static Object convert(Object value, Class<?> targetClass) {
        if (value.getClass().isAssignableFrom(targetClass)) {
            return value;
        }
        if (targetClass == String.class) {
            return value.toString();
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(value.toString());
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
            String v = value.toString().toLowerCase();
            if ("1".equals(v) || "true".equals(v)) {
                return Boolean.TRUE;
            }
            if ("0".equals(v) || "false".equals(v)) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Can not parse to boolean type of value: \"" + value + "\"");
        }
        if (targetClass == BigDecimal.class) {
            return new BigDecimal(value.toString());
        }
        if (targetClass == BigInteger.class) {
            return new BigInteger(value.toString());
        }
        if (targetClass == byte[].class) {
            return value.toString().getBytes();
        }
        if (targetClass == Date.class) {
            return ObjectUtil.parseDate(value);
        }
        if (targetClass == LocalDateTime.class) {
            return DateUtil.toLocalDateTime(ObjectUtil.parseDate(value));
        }
        if (targetClass == LocalDate.class) {
            return DateUtil.toLocalDate(ObjectUtil.parseDate(value));
        }
        if (targetClass == LocalTime.class) {
            return DateUtil.toLocalTime(ObjectUtil.parseDate(value));
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.parseShort(value.toString());
        }
        throw new RuntimeException("\"" + targetClass.getName() + "\" can not be parsed.");
    }

    private static Date parseDate(Object value) {
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        String s = value.toString();
        if (StrUtil.isNumeric(s)) {
            return new Date(Long.parseLong(s));
        }
        return DateUtil.parseDate(s);
    }

    public static Object getPrimitiveDefaultValue(Class<?> paraClass) {
        if (paraClass == Integer.TYPE || paraClass == Long.TYPE || paraClass == Float.TYPE || paraClass == Double.TYPE) {
            return 0;
        }
        if (paraClass == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (paraClass == Short.TYPE) {
            return (short)0;
        }
        if (paraClass == Byte.TYPE) {
            return (byte)0;
        }
        if (paraClass == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        return null;
    }
}

