/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.plugin.activerecord.Page;
import io.jboot.db.model.JbootModel;
import io.jboot.exception.JbootException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModelUtil {
    public static <M extends JbootModel<?>> List<M> copy(List<M> modelList) {
        if (modelList == null || modelList.isEmpty()) {
            return modelList;
        }
        List<JbootModel> list = modelList instanceof ArrayList ? new ArrayList(modelList.size()) : (List)ModelUtil.newInstance(modelList.getClass());
        for (JbootModel m : modelList) {
            list.add(ModelUtil.copy(m));
        }
        return list;
    }

    public static <M extends JbootModel<?>> Set<M> copy(Set<M> modelSet) {
        if (modelSet == null || modelSet.isEmpty()) {
            return modelSet;
        }
        Set<JbootModel> set = modelSet instanceof HashSet ? new HashSet(modelSet.size()) : (Set)ModelUtil.newInstance(modelSet.getClass());
        for (JbootModel m : modelSet) {
            set.add(ModelUtil.copy(m));
        }
        return set;
    }

    public static <M extends JbootModel<?>> M[] copy(M[] models) {
        if (models == null || models.length == 0) {
            return models;
        }
        JbootModel[] array = (JbootModel[])Array.newInstance(models.getClass().getComponentType(), models.length);
        int i = 0;
        for (M m : models) {
            array[i++] = ModelUtil.copy(m);
        }
        return array;
    }

    public static <M extends JbootModel<?>> Page<M> copy(Page<M> modelPage) {
        if (modelPage == null) {
            return null;
        }
        List modelList = modelPage.getList();
        if (modelList == null || modelList.isEmpty()) {
            return modelPage;
        }
        modelPage.setList(ModelUtil.copy(modelList));
        return modelPage;
    }

    public static <M extends JbootModel<?>> M copy(M model) {
        return model == null ? null : (M)model.copy();
    }

    private static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new JbootException("can not newInstance class:" + clazz + "\n" + e, e);
        }
    }
}

